/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.Node;

public class ListSignalCatalogNodesPublisher
implements SdkPublisher<ListSignalCatalogNodesResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListSignalCatalogNodesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSignalCatalogNodesPublisher(IoTFleetWiseAsyncClient client, ListSignalCatalogNodesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSignalCatalogNodesPublisher(IoTFleetWiseAsyncClient client, ListSignalCatalogNodesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSignalCatalogNodesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSignalCatalogNodesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Node> nodes() {
        Function<ListSignalCatalogNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSignalCatalogNodesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSignalCatalogNodesResponseFetcher
    implements AsyncPageFetcher<ListSignalCatalogNodesResponse> {
        private ListSignalCatalogNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalCatalogNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSignalCatalogNodesResponse> nextPage(ListSignalCatalogNodesResponse previousPage) {
            if (previousPage == null) {
                return ListSignalCatalogNodesPublisher.this.client.listSignalCatalogNodes(ListSignalCatalogNodesPublisher.this.firstRequest);
            }
            return ListSignalCatalogNodesPublisher.this.client.listSignalCatalogNodes((ListSignalCatalogNodesRequest)((Object)ListSignalCatalogNodesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

