/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpoolingMode {
    OFF("OFF"),
    TO_DISK("TO_DISK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpoolingMode> VALUE_MAP;
    private final String value;

    private SpoolingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpoolingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpoolingMode> knownValues() {
        EnumSet<SpoolingMode> knownValues = EnumSet.allOf(SpoolingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpoolingMode.class, SpoolingMode::toString);
    }
}

