/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A network interface that specifies the On-board diagnostic (OBD) II network protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObdInterface implements SdkPojo, Serializable, ToCopyableBuilder<ObdInterface.Builder, ObdInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ObdInterface::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> REQUEST_MESSAGE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("requestMessageId").getter(getter(ObdInterface::requestMessageId))
            .setter(setter(Builder::requestMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMessageId").build()).build();

    private static final SdkField<String> OBD_STANDARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("obdStandard").getter(getter(ObdInterface::obdStandard)).setter(setter(Builder::obdStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obdStandard").build()).build();

    private static final SdkField<Integer> PID_REQUEST_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("pidRequestIntervalSeconds")
            .getter(getter(ObdInterface::pidRequestIntervalSeconds)).setter(setter(Builder::pidRequestIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidRequestIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> DTC_REQUEST_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dtcRequestIntervalSeconds")
            .getter(getter(ObdInterface::dtcRequestIntervalSeconds)).setter(setter(Builder::dtcRequestIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dtcRequestIntervalSeconds").build())
            .build();

    private static final SdkField<Boolean> USE_EXTENDED_IDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useExtendedIds").getter(getter(ObdInterface::useExtendedIds)).setter(setter(Builder::useExtendedIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useExtendedIds").build()).build();

    private static final SdkField<Boolean> HAS_TRANSMISSION_ECU_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasTransmissionEcu").getter(getter(ObdInterface::hasTransmissionEcu))
            .setter(setter(Builder::hasTransmissionEcu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasTransmissionEcu").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REQUEST_MESSAGE_ID_FIELD, OBD_STANDARD_FIELD, PID_REQUEST_INTERVAL_SECONDS_FIELD, DTC_REQUEST_INTERVAL_SECONDS_FIELD,
            USE_EXTENDED_IDS_FIELD, HAS_TRANSMISSION_ECU_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer requestMessageId;

    private final String obdStandard;

    private final Integer pidRequestIntervalSeconds;

    private final Integer dtcRequestIntervalSeconds;

    private final Boolean useExtendedIds;

    private final Boolean hasTransmissionEcu;

    private ObdInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.requestMessageId = builder.requestMessageId;
        this.obdStandard = builder.obdStandard;
        this.pidRequestIntervalSeconds = builder.pidRequestIntervalSeconds;
        this.dtcRequestIntervalSeconds = builder.dtcRequestIntervalSeconds;
        this.useExtendedIds = builder.useExtendedIds;
        this.hasTransmissionEcu = builder.hasTransmissionEcu;
    }

    /**
     * <p>
     * The name of the interface.
     * </p>
     * 
     * @return The name of the interface.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the message requesting vehicle data.
     * </p>
     * 
     * @return The ID of the message requesting vehicle data.
     */
    public final Integer requestMessageId() {
        return requestMessageId;
    }

    /**
     * <p>
     * The standard OBD II PID.
     * </p>
     * 
     * @return The standard OBD II PID.
     */
    public final String obdStandard() {
        return obdStandard;
    }

    /**
     * <p>
     * The maximum number message requests per second.
     * </p>
     * 
     * @return The maximum number message requests per second.
     */
    public final Integer pidRequestIntervalSeconds() {
        return pidRequestIntervalSeconds;
    }

    /**
     * <p>
     * The maximum number message requests per diagnostic trouble code per second.
     * </p>
     * 
     * @return The maximum number message requests per diagnostic trouble code per second.
     */
    public final Integer dtcRequestIntervalSeconds() {
        return dtcRequestIntervalSeconds;
    }

    /**
     * <p>
     * Whether to use extended IDs in the message.
     * </p>
     * 
     * @return Whether to use extended IDs in the message.
     */
    public final Boolean useExtendedIds() {
        return useExtendedIds;
    }

    /**
     * <p>
     * Whether the vehicle has a transmission control module (TCM).
     * </p>
     * 
     * @return Whether the vehicle has a transmission control module (TCM).
     */
    public final Boolean hasTransmissionEcu() {
        return hasTransmissionEcu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(obdStandard());
        hashCode = 31 * hashCode + Objects.hashCode(pidRequestIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(dtcRequestIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(useExtendedIds());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransmissionEcu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObdInterface)) {
            return false;
        }
        ObdInterface other = (ObdInterface) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(requestMessageId(), other.requestMessageId())
                && Objects.equals(obdStandard(), other.obdStandard())
                && Objects.equals(pidRequestIntervalSeconds(), other.pidRequestIntervalSeconds())
                && Objects.equals(dtcRequestIntervalSeconds(), other.dtcRequestIntervalSeconds())
                && Objects.equals(useExtendedIds(), other.useExtendedIds())
                && Objects.equals(hasTransmissionEcu(), other.hasTransmissionEcu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObdInterface").add("Name", name()).add("RequestMessageId", requestMessageId())
                .add("ObdStandard", obdStandard()).add("PidRequestIntervalSeconds", pidRequestIntervalSeconds())
                .add("DtcRequestIntervalSeconds", dtcRequestIntervalSeconds()).add("UseExtendedIds", useExtendedIds())
                .add("HasTransmissionEcu", hasTransmissionEcu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "requestMessageId":
            return Optional.ofNullable(clazz.cast(requestMessageId()));
        case "obdStandard":
            return Optional.ofNullable(clazz.cast(obdStandard()));
        case "pidRequestIntervalSeconds":
            return Optional.ofNullable(clazz.cast(pidRequestIntervalSeconds()));
        case "dtcRequestIntervalSeconds":
            return Optional.ofNullable(clazz.cast(dtcRequestIntervalSeconds()));
        case "useExtendedIds":
            return Optional.ofNullable(clazz.cast(useExtendedIds()));
        case "hasTransmissionEcu":
            return Optional.ofNullable(clazz.cast(hasTransmissionEcu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObdInterface, T> g) {
        return obj -> g.apply((ObdInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObdInterface> {
        /**
         * <p>
         * The name of the interface.
         * </p>
         * 
         * @param name
         *        The name of the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the message requesting vehicle data.
         * </p>
         * 
         * @param requestMessageId
         *        The ID of the message requesting vehicle data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMessageId(Integer requestMessageId);

        /**
         * <p>
         * The standard OBD II PID.
         * </p>
         * 
         * @param obdStandard
         *        The standard OBD II PID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder obdStandard(String obdStandard);

        /**
         * <p>
         * The maximum number message requests per second.
         * </p>
         * 
         * @param pidRequestIntervalSeconds
         *        The maximum number message requests per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pidRequestIntervalSeconds(Integer pidRequestIntervalSeconds);

        /**
         * <p>
         * The maximum number message requests per diagnostic trouble code per second.
         * </p>
         * 
         * @param dtcRequestIntervalSeconds
         *        The maximum number message requests per diagnostic trouble code per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dtcRequestIntervalSeconds(Integer dtcRequestIntervalSeconds);

        /**
         * <p>
         * Whether to use extended IDs in the message.
         * </p>
         * 
         * @param useExtendedIds
         *        Whether to use extended IDs in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useExtendedIds(Boolean useExtendedIds);

        /**
         * <p>
         * Whether the vehicle has a transmission control module (TCM).
         * </p>
         * 
         * @param hasTransmissionEcu
         *        Whether the vehicle has a transmission control module (TCM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasTransmissionEcu(Boolean hasTransmissionEcu);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer requestMessageId;

        private String obdStandard;

        private Integer pidRequestIntervalSeconds;

        private Integer dtcRequestIntervalSeconds;

        private Boolean useExtendedIds;

        private Boolean hasTransmissionEcu;

        private BuilderImpl() {
        }

        private BuilderImpl(ObdInterface model) {
            name(model.name);
            requestMessageId(model.requestMessageId);
            obdStandard(model.obdStandard);
            pidRequestIntervalSeconds(model.pidRequestIntervalSeconds);
            dtcRequestIntervalSeconds(model.dtcRequestIntervalSeconds);
            useExtendedIds(model.useExtendedIds);
            hasTransmissionEcu(model.hasTransmissionEcu);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRequestMessageId() {
            return requestMessageId;
        }

        public final void setRequestMessageId(Integer requestMessageId) {
            this.requestMessageId = requestMessageId;
        }

        @Override
        public final Builder requestMessageId(Integer requestMessageId) {
            this.requestMessageId = requestMessageId;
            return this;
        }

        public final String getObdStandard() {
            return obdStandard;
        }

        public final void setObdStandard(String obdStandard) {
            this.obdStandard = obdStandard;
        }

        @Override
        public final Builder obdStandard(String obdStandard) {
            this.obdStandard = obdStandard;
            return this;
        }

        public final Integer getPidRequestIntervalSeconds() {
            return pidRequestIntervalSeconds;
        }

        public final void setPidRequestIntervalSeconds(Integer pidRequestIntervalSeconds) {
            this.pidRequestIntervalSeconds = pidRequestIntervalSeconds;
        }

        @Override
        public final Builder pidRequestIntervalSeconds(Integer pidRequestIntervalSeconds) {
            this.pidRequestIntervalSeconds = pidRequestIntervalSeconds;
            return this;
        }

        public final Integer getDtcRequestIntervalSeconds() {
            return dtcRequestIntervalSeconds;
        }

        public final void setDtcRequestIntervalSeconds(Integer dtcRequestIntervalSeconds) {
            this.dtcRequestIntervalSeconds = dtcRequestIntervalSeconds;
        }

        @Override
        public final Builder dtcRequestIntervalSeconds(Integer dtcRequestIntervalSeconds) {
            this.dtcRequestIntervalSeconds = dtcRequestIntervalSeconds;
            return this;
        }

        public final Boolean getUseExtendedIds() {
            return useExtendedIds;
        }

        public final void setUseExtendedIds(Boolean useExtendedIds) {
            this.useExtendedIds = useExtendedIds;
        }

        @Override
        public final Builder useExtendedIds(Boolean useExtendedIds) {
            this.useExtendedIds = useExtendedIds;
            return this;
        }

        public final Boolean getHasTransmissionEcu() {
            return hasTransmissionEcu;
        }

        public final void setHasTransmissionEcu(Boolean hasTransmissionEcu) {
            this.hasTransmissionEcu = hasTransmissionEcu;
        }

        @Override
        public final Builder hasTransmissionEcu(Boolean hasTransmissionEcu) {
            this.hasTransmissionEcu = hasTransmissionEcu;
            return this;
        }

        @Override
        public ObdInterface build() {
            return new ObdInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
