/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegisterAccountStatusResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<GetRegisterAccountStatusResponse.Builder, GetRegisterAccountStatusResponse> {
    private static final SdkField<String> CUSTOMER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAccountId").getter(getter(GetRegisterAccountStatusResponse::customerAccountId))
            .setter(setter(Builder::customerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAccountId").build()).build();

    private static final SdkField<String> ACCOUNT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountStatus").getter(getter(GetRegisterAccountStatusResponse::accountStatusAsString))
            .setter(setter(Builder::accountStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountStatus").build()).build();

    private static final SdkField<TimestreamRegistrationResponse> TIMESTREAM_REGISTRATION_RESPONSE_FIELD = SdkField
            .<TimestreamRegistrationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("timestreamRegistrationResponse")
            .getter(getter(GetRegisterAccountStatusResponse::timestreamRegistrationResponse))
            .setter(setter(Builder::timestreamRegistrationResponse))
            .constructor(TimestreamRegistrationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamRegistrationResponse")
                    .build()).build();

    private static final SdkField<IamRegistrationResponse> IAM_REGISTRATION_RESPONSE_FIELD = SdkField
            .<IamRegistrationResponse> builder(MarshallingType.SDK_POJO).memberName("iamRegistrationResponse")
            .getter(getter(GetRegisterAccountStatusResponse::iamRegistrationResponse))
            .setter(setter(Builder::iamRegistrationResponse)).constructor(IamRegistrationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRegistrationResponse").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetRegisterAccountStatusResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(GetRegisterAccountStatusResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ACCOUNT_ID_FIELD,
            ACCOUNT_STATUS_FIELD, TIMESTREAM_REGISTRATION_RESPONSE_FIELD, IAM_REGISTRATION_RESPONSE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private final String customerAccountId;

    private final String accountStatus;

    private final TimestreamRegistrationResponse timestreamRegistrationResponse;

    private final IamRegistrationResponse iamRegistrationResponse;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private GetRegisterAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.customerAccountId = builder.customerAccountId;
        this.accountStatus = builder.accountStatus;
        this.timestreamRegistrationResponse = builder.timestreamRegistrationResponse;
        this.iamRegistrationResponse = builder.iamRegistrationResponse;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The unique ID of the Amazon Web Services account, provided at account creation.
     * </p>
     * 
     * @return The unique ID of the Amazon Web Services account, provided at account creation.
     */
    public final String customerAccountId() {
        return customerAccountId;
    }

    /**
     * <p>
     * The status of registering your account and resources. The status can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration request.
     * This process takes approximately five minutes to complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource. Try again
     * later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountStatus}
     * will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountStatusAsString}.
     * </p>
     * 
     * @return The status of registering your account and resources. The status can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration
     *         request. This process takes approximately five minutes to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource.
     *         Try again later.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final RegistrationStatus accountStatus() {
        return RegistrationStatus.fromValue(accountStatus);
    }

    /**
     * <p>
     * The status of registering your account and resources. The status can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration request.
     * This process takes approximately five minutes to complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource. Try again
     * later.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountStatus}
     * will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountStatusAsString}.
     * </p>
     * 
     * @return The status of registering your account and resources. The status can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration
     *         request. This process takes approximately five minutes to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource.
     *         Try again later.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final String accountStatusAsString() {
        return accountStatus;
    }

    /**
     * <p>
     * Information about the registered Amazon Timestream resources or errors, if any.
     * </p>
     * 
     * @return Information about the registered Amazon Timestream resources or errors, if any.
     */
    public final TimestreamRegistrationResponse timestreamRegistrationResponse() {
        return timestreamRegistrationResponse;
    }

    /**
     * <p>
     * Information about the registered IAM resources or errors, if any.
     * </p>
     * 
     * @return Information about the registered IAM resources or errors, if any.
     */
    public final IamRegistrationResponse iamRegistrationResponse() {
        return iamRegistrationResponse;
    }

    /**
     * <p>
     * The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC
     *         time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamRegistrationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(iamRegistrationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegisterAccountStatusResponse)) {
            return false;
        }
        GetRegisterAccountStatusResponse other = (GetRegisterAccountStatusResponse) obj;
        return Objects.equals(customerAccountId(), other.customerAccountId())
                && Objects.equals(accountStatusAsString(), other.accountStatusAsString())
                && Objects.equals(timestreamRegistrationResponse(), other.timestreamRegistrationResponse())
                && Objects.equals(iamRegistrationResponse(), other.iamRegistrationResponse())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegisterAccountStatusResponse").add("CustomerAccountId", customerAccountId())
                .add("AccountStatus", accountStatusAsString())
                .add("TimestreamRegistrationResponse", timestreamRegistrationResponse())
                .add("IamRegistrationResponse", iamRegistrationResponse()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerAccountId":
            return Optional.ofNullable(clazz.cast(customerAccountId()));
        case "accountStatus":
            return Optional.ofNullable(clazz.cast(accountStatusAsString()));
        case "timestreamRegistrationResponse":
            return Optional.ofNullable(clazz.cast(timestreamRegistrationResponse()));
        case "iamRegistrationResponse":
            return Optional.ofNullable(clazz.cast(iamRegistrationResponse()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRegisterAccountStatusResponse, T> g) {
        return obj -> g.apply((GetRegisterAccountStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRegisterAccountStatusResponse> {
        /**
         * <p>
         * The unique ID of the Amazon Web Services account, provided at account creation.
         * </p>
         * 
         * @param customerAccountId
         *        The unique ID of the Amazon Web Services account, provided at account creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAccountId(String customerAccountId);

        /**
         * <p>
         * The status of registering your account and resources. The status can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration request.
         * This process takes approximately five minutes to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource. Try
         * again later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param accountStatus
         *        The status of registering your account and resources. The status can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration
         *        request. This process takes approximately five minutes to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource.
         *        Try again later.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder accountStatus(String accountStatus);

        /**
         * <p>
         * The status of registering your account and resources. The status can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration request.
         * This process takes approximately five minutes to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource. Try
         * again later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param accountStatus
         *        The status of registering your account and resources. The status can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration
         *        request. This process takes approximately five minutes to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can't register the AWS resource.
         *        Try again later.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder accountStatus(RegistrationStatus accountStatus);

        /**
         * <p>
         * Information about the registered Amazon Timestream resources or errors, if any.
         * </p>
         * 
         * @param timestreamRegistrationResponse
         *        Information about the registered Amazon Timestream resources or errors, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamRegistrationResponse(TimestreamRegistrationResponse timestreamRegistrationResponse);

        /**
         * <p>
         * Information about the registered Amazon Timestream resources or errors, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestreamRegistrationResponse.Builder}
         * avoiding the need to create one manually via {@link TimestreamRegistrationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamRegistrationResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #timestreamRegistrationResponse(TimestreamRegistrationResponse)}.
         * 
         * @param timestreamRegistrationResponse
         *        a consumer that will call methods on {@link TimestreamRegistrationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamRegistrationResponse(TimestreamRegistrationResponse)
         */
        default Builder timestreamRegistrationResponse(
                Consumer<TimestreamRegistrationResponse.Builder> timestreamRegistrationResponse) {
            return timestreamRegistrationResponse(TimestreamRegistrationResponse.builder()
                    .applyMutation(timestreamRegistrationResponse).build());
        }

        /**
         * <p>
         * Information about the registered IAM resources or errors, if any.
         * </p>
         * 
         * @param iamRegistrationResponse
         *        Information about the registered IAM resources or errors, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRegistrationResponse(IamRegistrationResponse iamRegistrationResponse);

        /**
         * <p>
         * Information about the registered IAM resources or errors, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamRegistrationResponse.Builder} avoiding
         * the need to create one manually via {@link IamRegistrationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamRegistrationResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #iamRegistrationResponse(IamRegistrationResponse)}.
         * 
         * @param iamRegistrationResponse
         *        a consumer that will call methods on {@link IamRegistrationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRegistrationResponse(IamRegistrationResponse)
         */
        default Builder iamRegistrationResponse(Consumer<IamRegistrationResponse.Builder> iamRegistrationResponse) {
            return iamRegistrationResponse(IamRegistrationResponse.builder().applyMutation(iamRegistrationResponse).build());
        }

        /**
         * <p>
         * The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String customerAccountId;

        private String accountStatus;

        private TimestreamRegistrationResponse timestreamRegistrationResponse;

        private IamRegistrationResponse iamRegistrationResponse;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegisterAccountStatusResponse model) {
            super(model);
            customerAccountId(model.customerAccountId);
            accountStatus(model.accountStatus);
            timestreamRegistrationResponse(model.timestreamRegistrationResponse);
            iamRegistrationResponse(model.iamRegistrationResponse);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getCustomerAccountId() {
            return customerAccountId;
        }

        public final void setCustomerAccountId(String customerAccountId) {
            this.customerAccountId = customerAccountId;
        }

        @Override
        public final Builder customerAccountId(String customerAccountId) {
            this.customerAccountId = customerAccountId;
            return this;
        }

        public final String getAccountStatus() {
            return accountStatus;
        }

        public final void setAccountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
        }

        @Override
        public final Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        @Override
        public final Builder accountStatus(RegistrationStatus accountStatus) {
            this.accountStatus(accountStatus == null ? null : accountStatus.toString());
            return this;
        }

        public final TimestreamRegistrationResponse.Builder getTimestreamRegistrationResponse() {
            return timestreamRegistrationResponse != null ? timestreamRegistrationResponse.toBuilder() : null;
        }

        public final void setTimestreamRegistrationResponse(
                TimestreamRegistrationResponse.BuilderImpl timestreamRegistrationResponse) {
            this.timestreamRegistrationResponse = timestreamRegistrationResponse != null ? timestreamRegistrationResponse.build()
                    : null;
        }

        @Override
        public final Builder timestreamRegistrationResponse(TimestreamRegistrationResponse timestreamRegistrationResponse) {
            this.timestreamRegistrationResponse = timestreamRegistrationResponse;
            return this;
        }

        public final IamRegistrationResponse.Builder getIamRegistrationResponse() {
            return iamRegistrationResponse != null ? iamRegistrationResponse.toBuilder() : null;
        }

        public final void setIamRegistrationResponse(IamRegistrationResponse.BuilderImpl iamRegistrationResponse) {
            this.iamRegistrationResponse = iamRegistrationResponse != null ? iamRegistrationResponse.build() : null;
        }

        @Override
        public final Builder iamRegistrationResponse(IamRegistrationResponse iamRegistrationResponse) {
            this.iamRegistrationResponse = iamRegistrationResponse;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public GetRegisterAccountStatusResponse build() {
            return new GetRegisterAccountStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
