/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a created decoder manifest. You can use the API operation to return this information about multiple
 * decoder manifests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecoderManifestSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DecoderManifestSummary.Builder, DecoderManifestSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DecoderManifestSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DecoderManifestSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(DecoderManifestSummary::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DecoderManifestSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DecoderManifestSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DecoderManifestSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(DecoderManifestSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            MODEL_MANIFEST_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String modelManifestArn;

    private final String description;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DecoderManifestSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.modelManifestArn = builder.modelManifestArn;
        this.description = builder.description;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The name of the decoder manifest.
     * </p>
     * 
     * @return The name of the decoder manifest.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     * </p>
     * 
     * @return The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     * </p>
     * 
     * @return The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * <p>
     * A brief description of the decoder manifest.
     * </p>
     * 
     * @return A brief description of the decoder manifest.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be edited. If
     * the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
     *         edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
     * @see ManifestStatus
     */
    public final ManifestStatus status() {
        return ManifestStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be edited. If
     * the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
     *         edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
     * @see ManifestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC
     *         time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecoderManifestSummary)) {
            return false;
        }
        DecoderManifestSummary other = (DecoderManifestSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(modelManifestArn(), other.modelManifestArn())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecoderManifestSummary").add("Name", name()).add("Arn", arn())
                .add("ModelManifestArn", modelManifestArn()).add("Description", description()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecoderManifestSummary, T> g) {
        return obj -> g.apply((DecoderManifestSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecoderManifestSummary> {
        /**
         * <p>
         * The name of the decoder manifest.
         * </p>
         * 
         * @param name
         *        The name of the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
         * </p>
         * 
         * @param arn
         *        The ARN of a vehicle model (model manifest) associated with the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
         * </p>
         * 
         * @param modelManifestArn
         *        The ARN of a vehicle model (model manifest) associated with the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * A brief description of the decoder manifest.
         * </p>
         * 
         * @param description
         *        A brief description of the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         * edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
         * </p>
         * 
         * @param status
         *        The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         *        edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         * edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
         * </p>
         * 
         * @param status
         *        The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         *        edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(ManifestStatus status);

        /**
         * <p>
         * The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String modelManifestArn;

        private String description;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DecoderManifestSummary model) {
            name(model.name);
            arn(model.arn);
            modelManifestArn(model.modelManifestArn);
            description(model.description);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManifestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public DecoderManifestSummary build() {
            return new DecoderManifestSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
