/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleethub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotfleethub.DefaultIoTFleetHubBaseClientBuilder;
import software.amazon.awssdk.services.iotfleethub.DefaultIoTFleetHubClient;
import software.amazon.awssdk.services.iotfleethub.IoTFleetHubClient;
import software.amazon.awssdk.services.iotfleethub.IoTFleetHubClientBuilder;
import software.amazon.awssdk.services.iotfleethub.IoTFleetHubServiceClientConfiguration;
import software.amazon.awssdk.services.iotfleethub.endpoints.IoTFleetHubEndpointProvider;

@SdkInternalApi
final class DefaultIoTFleetHubClientBuilder
extends DefaultIoTFleetHubBaseClientBuilder<IoTFleetHubClientBuilder, IoTFleetHubClient>
implements IoTFleetHubClientBuilder {
    DefaultIoTFleetHubClientBuilder() {
    }

    @Override
    public DefaultIoTFleetHubClientBuilder endpointProvider(IoTFleetHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTFleetHubClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIoTFleetHubClientBuilder.validateClientOptions(clientConfiguration);
        IoTFleetHubServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTFleetHubClient client = new DefaultIoTFleetHubClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTFleetHubServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTFleetHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

