/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that defines a state of a detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class State implements SdkPojo, Serializable, ToCopyableBuilder<State.Builder, State> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(State::stateName)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<OnInputLifecycle> ON_INPUT_FIELD = SdkField
            .<OnInputLifecycle> builder(MarshallingType.SDK_POJO).memberName("onInput").getter(getter(State::onInput))
            .setter(setter(Builder::onInput)).constructor(OnInputLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onInput").build()).build();

    private static final SdkField<OnEnterLifecycle> ON_ENTER_FIELD = SdkField
            .<OnEnterLifecycle> builder(MarshallingType.SDK_POJO).memberName("onEnter").getter(getter(State::onEnter))
            .setter(setter(Builder::onEnter)).constructor(OnEnterLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onEnter").build()).build();

    private static final SdkField<OnExitLifecycle> ON_EXIT_FIELD = SdkField.<OnExitLifecycle> builder(MarshallingType.SDK_POJO)
            .memberName("onExit").getter(getter(State::onExit)).setter(setter(Builder::onExit))
            .constructor(OnExitLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onExit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD,
            ON_INPUT_FIELD, ON_ENTER_FIELD, ON_EXIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stateName;

    private final OnInputLifecycle onInput;

    private final OnEnterLifecycle onEnter;

    private final OnExitLifecycle onExit;

    private State(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.onInput = builder.onInput;
        this.onEnter = builder.onEnter;
        this.onExit = builder.onExit;
    }

    /**
     * <p>
     * The name of the state.
     * </p>
     * 
     * @return The name of the state.
     */
    public final String stateName() {
        return stateName;
    }

    /**
     * <p>
     * When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.
     * </p>
     * 
     * @return When an input is received and the <code>condition</code> is TRUE, perform the specified
     *         <code>actions</code>.
     */
    public final OnInputLifecycle onInput() {
        return onInput;
    }

    /**
     * <p>
     * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
     * </p>
     * 
     * @return When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
     */
    public final OnEnterLifecycle onEnter() {
        return onEnter;
    }

    /**
     * <p>
     * When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is
     * <code>TRUE</code>.
     * </p>
     * 
     * @return When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is
     *         <code>TRUE</code>.
     */
    public final OnExitLifecycle onExit() {
        return onExit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateName());
        hashCode = 31 * hashCode + Objects.hashCode(onInput());
        hashCode = 31 * hashCode + Objects.hashCode(onEnter());
        hashCode = 31 * hashCode + Objects.hashCode(onExit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof State)) {
            return false;
        }
        State other = (State) obj;
        return Objects.equals(stateName(), other.stateName()) && Objects.equals(onInput(), other.onInput())
                && Objects.equals(onEnter(), other.onEnter()) && Objects.equals(onExit(), other.onExit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("State").add("StateName", stateName()).add("OnInput", onInput()).add("OnEnter", onEnter())
                .add("OnExit", onExit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateName()));
        case "onInput":
            return Optional.ofNullable(clazz.cast(onInput()));
        case "onEnter":
            return Optional.ofNullable(clazz.cast(onEnter()));
        case "onExit":
            return Optional.ofNullable(clazz.cast(onExit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<State, T> g) {
        return obj -> g.apply((State) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, State> {
        /**
         * <p>
         * The name of the state.
         * </p>
         * 
         * @param stateName
         *        The name of the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.
         * </p>
         * 
         * @param onInput
         *        When an input is received and the <code>condition</code> is TRUE, perform the specified
         *        <code>actions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onInput(OnInputLifecycle onInput);

        /**
         * <p>
         * When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnInputLifecycle.Builder} avoiding the
         * need to create one manually via {@link OnInputLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnInputLifecycle.Builder#build()} is called immediately and its
         * result is passed to {@link #onInput(OnInputLifecycle)}.
         * 
         * @param onInput
         *        a consumer that will call methods on {@link OnInputLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onInput(OnInputLifecycle)
         */
        default Builder onInput(Consumer<OnInputLifecycle.Builder> onInput) {
            return onInput(OnInputLifecycle.builder().applyMutation(onInput).build());
        }

        /**
         * <p>
         * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
         * </p>
         * 
         * @param onEnter
         *        When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onEnter(OnEnterLifecycle onEnter);

        /**
         * <p>
         * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnEnterLifecycle.Builder} avoiding the
         * need to create one manually via {@link OnEnterLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnEnterLifecycle.Builder#build()} is called immediately and its
         * result is passed to {@link #onEnter(OnEnterLifecycle)}.
         * 
         * @param onEnter
         *        a consumer that will call methods on {@link OnEnterLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onEnter(OnEnterLifecycle)
         */
        default Builder onEnter(Consumer<OnEnterLifecycle.Builder> onEnter) {
            return onEnter(OnEnterLifecycle.builder().applyMutation(onEnter).build());
        }

        /**
         * <p>
         * When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is
         * <code>TRUE</code>.
         * </p>
         * 
         * @param onExit
         *        When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is
         *        <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExit(OnExitLifecycle onExit);

        /**
         * <p>
         * When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is
         * <code>TRUE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnExitLifecycle.Builder} avoiding the
         * need to create one manually via {@link OnExitLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnExitLifecycle.Builder#build()} is called immediately and its
         * result is passed to {@link #onExit(OnExitLifecycle)}.
         * 
         * @param onExit
         *        a consumer that will call methods on {@link OnExitLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onExit(OnExitLifecycle)
         */
        default Builder onExit(Consumer<OnExitLifecycle.Builder> onExit) {
            return onExit(OnExitLifecycle.builder().applyMutation(onExit).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stateName;

        private OnInputLifecycle onInput;

        private OnEnterLifecycle onEnter;

        private OnExitLifecycle onExit;

        private BuilderImpl() {
        }

        private BuilderImpl(State model) {
            stateName(model.stateName);
            onInput(model.onInput);
            onEnter(model.onEnter);
            onExit(model.onExit);
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final OnInputLifecycle.Builder getOnInput() {
            return onInput != null ? onInput.toBuilder() : null;
        }

        public final void setOnInput(OnInputLifecycle.BuilderImpl onInput) {
            this.onInput = onInput != null ? onInput.build() : null;
        }

        @Override
        public final Builder onInput(OnInputLifecycle onInput) {
            this.onInput = onInput;
            return this;
        }

        public final OnEnterLifecycle.Builder getOnEnter() {
            return onEnter != null ? onEnter.toBuilder() : null;
        }

        public final void setOnEnter(OnEnterLifecycle.BuilderImpl onEnter) {
            this.onEnter = onEnter != null ? onEnter.build() : null;
        }

        @Override
        public final Builder onEnter(OnEnterLifecycle onEnter) {
            this.onEnter = onEnter;
            return this;
        }

        public final OnExitLifecycle.Builder getOnExit() {
            return onExit != null ? onExit.toBuilder() : null;
        }

        public final void setOnExit(OnExitLifecycle.BuilderImpl onExit) {
            this.onExit = onExit != null ? onExit.build() : null;
        }

        @Override
        public final Builder onExit(OnExitLifecycle onExit) {
            this.onExit = onExit;
            return this;
        }

        @Override
        public State build() {
            return new State(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
