/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required to publish the MQTT message through the AWS IoT message broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotTopicPublishAction implements SdkPojo, Serializable,
        ToCopyableBuilder<IotTopicPublishAction.Builder, IotTopicPublishAction> {
    private static final SdkField<String> MQTT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mqttTopic").getter(getter(IotTopicPublishAction::mqttTopic)).setter(setter(Builder::mqttTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttTopic").build()).build();

    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.<Payload> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(IotTopicPublishAction::payload)).setter(setter(Builder::payload))
            .constructor(Payload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MQTT_TOPIC_FIELD,
            PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mqttTopic;

    private final Payload payload;

    private IotTopicPublishAction(BuilderImpl builder) {
        this.mqttTopic = builder.mqttTopic;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The MQTT topic of the message. You can use a string expression that includes variables (
     * <code>$variable.&lt;variable-name&gt;</code>) and input values (
     * <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the topic string.
     * </p>
     * 
     * @return The MQTT topic of the message. You can use a string expression that includes variables (
     *         <code>$variable.&lt;variable-name&gt;</code>) and input values (
     *         <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the topic string.
     */
    public final String mqttTopic() {
        return mqttTopic;
    }

    /**
     * <p>
     * You can configure the action payload when you publish a message to an AWS IoT Core topic.
     * </p>
     * 
     * @return You can configure the action payload when you publish a message to an AWS IoT Core topic.
     */
    public final Payload payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mqttTopic());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotTopicPublishAction)) {
            return false;
        }
        IotTopicPublishAction other = (IotTopicPublishAction) obj;
        return Objects.equals(mqttTopic(), other.mqttTopic()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotTopicPublishAction").add("MqttTopic", mqttTopic()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mqttTopic":
            return Optional.ofNullable(clazz.cast(mqttTopic()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotTopicPublishAction, T> g) {
        return obj -> g.apply((IotTopicPublishAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotTopicPublishAction> {
        /**
         * <p>
         * The MQTT topic of the message. You can use a string expression that includes variables (
         * <code>$variable.&lt;variable-name&gt;</code>) and input values (
         * <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the topic string.
         * </p>
         * 
         * @param mqttTopic
         *        The MQTT topic of the message. You can use a string expression that includes variables (
         *        <code>$variable.&lt;variable-name&gt;</code>) and input values (
         *        <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the topic string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqttTopic(String mqttTopic);

        /**
         * <p>
         * You can configure the action payload when you publish a message to an AWS IoT Core topic.
         * </p>
         * 
         * @param payload
         *        You can configure the action payload when you publish a message to an AWS IoT Core topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Payload payload);

        /**
         * <p>
         * You can configure the action payload when you publish a message to an AWS IoT Core topic.
         * </p>
         * This is a convenience method that creates an instance of the {@link Payload.Builder} avoiding the need to
         * create one manually via {@link Payload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Payload.Builder#build()} is called immediately and its result is
         * passed to {@link #payload(Payload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Payload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Payload)
         */
        default Builder payload(Consumer<Payload.Builder> payload) {
            return payload(Payload.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mqttTopic;

        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(IotTopicPublishAction model) {
            mqttTopic(model.mqttTopic);
            payload(model.payload);
        }

        public final String getMqttTopic() {
            return mqttTopic;
        }

        public final void setMqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
        }

        @Override
        public final Builder mqttTopic(String mqttTopic) {
            this.mqttTopic = mqttTopic;
            return this;
        }

        public final Payload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public IotTopicPublishAction build() {
            return new IotTopicPublishAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
