/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifer of the input routed from AWS IoT SiteWise.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotSiteWiseInputIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<IotSiteWiseInputIdentifier.Builder, IotSiteWiseInputIdentifier> {
    private static final SdkField<IotSiteWiseAssetModelPropertyIdentifier> IOT_SITE_WISE_ASSET_MODEL_PROPERTY_IDENTIFIER_FIELD = SdkField
            .<IotSiteWiseAssetModelPropertyIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("iotSiteWiseAssetModelPropertyIdentifier")
            .getter(getter(IotSiteWiseInputIdentifier::iotSiteWiseAssetModelPropertyIdentifier))
            .setter(setter(Builder::iotSiteWiseAssetModelPropertyIdentifier))
            .constructor(IotSiteWiseAssetModelPropertyIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("iotSiteWiseAssetModelPropertyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IOT_SITE_WISE_ASSET_MODEL_PROPERTY_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final IotSiteWiseAssetModelPropertyIdentifier iotSiteWiseAssetModelPropertyIdentifier;

    private IotSiteWiseInputIdentifier(BuilderImpl builder) {
        this.iotSiteWiseAssetModelPropertyIdentifier = builder.iotSiteWiseAssetModelPropertyIdentifier;
    }

    /**
     * <p>
     * The identifier of the AWS IoT SiteWise asset model property.
     * </p>
     * 
     * @return The identifier of the AWS IoT SiteWise asset model property.
     */
    public final IotSiteWiseAssetModelPropertyIdentifier iotSiteWiseAssetModelPropertyIdentifier() {
        return iotSiteWiseAssetModelPropertyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseAssetModelPropertyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseInputIdentifier)) {
            return false;
        }
        IotSiteWiseInputIdentifier other = (IotSiteWiseInputIdentifier) obj;
        return Objects.equals(iotSiteWiseAssetModelPropertyIdentifier(), other.iotSiteWiseAssetModelPropertyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotSiteWiseInputIdentifier")
                .add("IotSiteWiseAssetModelPropertyIdentifier", iotSiteWiseAssetModelPropertyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iotSiteWiseAssetModelPropertyIdentifier":
            return Optional.ofNullable(clazz.cast(iotSiteWiseAssetModelPropertyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseInputIdentifier, T> g) {
        return obj -> g.apply((IotSiteWiseInputIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotSiteWiseInputIdentifier> {
        /**
         * <p>
         * The identifier of the AWS IoT SiteWise asset model property.
         * </p>
         * 
         * @param iotSiteWiseAssetModelPropertyIdentifier
         *        The identifier of the AWS IoT SiteWise asset model property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseAssetModelPropertyIdentifier(
                IotSiteWiseAssetModelPropertyIdentifier iotSiteWiseAssetModelPropertyIdentifier);

        /**
         * <p>
         * The identifier of the AWS IoT SiteWise asset model property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IotSiteWiseAssetModelPropertyIdentifier.Builder} avoiding the need to create one manually via
         * {@link IotSiteWiseAssetModelPropertyIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotSiteWiseAssetModelPropertyIdentifier.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #iotSiteWiseAssetModelPropertyIdentifier(IotSiteWiseAssetModelPropertyIdentifier)}.
         * 
         * @param iotSiteWiseAssetModelPropertyIdentifier
         *        a consumer that will call methods on {@link IotSiteWiseAssetModelPropertyIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseAssetModelPropertyIdentifier(IotSiteWiseAssetModelPropertyIdentifier)
         */
        default Builder iotSiteWiseAssetModelPropertyIdentifier(
                Consumer<IotSiteWiseAssetModelPropertyIdentifier.Builder> iotSiteWiseAssetModelPropertyIdentifier) {
            return iotSiteWiseAssetModelPropertyIdentifier(IotSiteWiseAssetModelPropertyIdentifier.builder()
                    .applyMutation(iotSiteWiseAssetModelPropertyIdentifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IotSiteWiseAssetModelPropertyIdentifier iotSiteWiseAssetModelPropertyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseInputIdentifier model) {
            iotSiteWiseAssetModelPropertyIdentifier(model.iotSiteWiseAssetModelPropertyIdentifier);
        }

        public final IotSiteWiseAssetModelPropertyIdentifier.Builder getIotSiteWiseAssetModelPropertyIdentifier() {
            return iotSiteWiseAssetModelPropertyIdentifier != null ? iotSiteWiseAssetModelPropertyIdentifier.toBuilder() : null;
        }

        public final void setIotSiteWiseAssetModelPropertyIdentifier(
                IotSiteWiseAssetModelPropertyIdentifier.BuilderImpl iotSiteWiseAssetModelPropertyIdentifier) {
            this.iotSiteWiseAssetModelPropertyIdentifier = iotSiteWiseAssetModelPropertyIdentifier != null ? iotSiteWiseAssetModelPropertyIdentifier
                    .build() : null;
        }

        @Override
        public final Builder iotSiteWiseAssetModelPropertyIdentifier(
                IotSiteWiseAssetModelPropertyIdentifier iotSiteWiseAssetModelPropertyIdentifier) {
            this.iotSiteWiseAssetModelPropertyIdentifier = iotSiteWiseAssetModelPropertyIdentifier;
            return this;
        }

        @Override
        public IotSiteWiseInputIdentifier build() {
            return new IotSiteWiseInputIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
