/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<DescribeAlarmModelRequest.Builder, DescribeAlarmModelRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(DescribeAlarmModelRequest::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelVersion").getter(getter(DescribeAlarmModelRequest::alarmModelVersion))
            .setter(setter(Builder::alarmModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_VERSION_FIELD));

    private final String alarmModelName;

    private final String alarmModelVersion;

    private DescribeAlarmModelRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelVersion = builder.alarmModelVersion;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The version of the alarm model.
     * </p>
     * 
     * @return The version of the alarm model.
     */
    public final String alarmModelVersion() {
        return alarmModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmModelRequest)) {
            return false;
        }
        DescribeAlarmModelRequest other = (DescribeAlarmModelRequest) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelVersion(), other.alarmModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmModelRequest").add("AlarmModelName", alarmModelName())
                .add("AlarmModelVersion", alarmModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelVersion":
            return Optional.ofNullable(clazz.cast(alarmModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmModelRequest, T> g) {
        return obj -> g.apply((DescribeAlarmModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmModelRequest> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The version of the alarm model.
         * </p>
         * 
         * @param alarmModelVersion
         *        The version of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersion(String alarmModelVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmModelRequest model) {
            super(model);
            alarmModelName(model.alarmModelName);
            alarmModelVersion(model.alarmModelVersion);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelVersion() {
            return alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmModelRequest build() {
            return new DescribeAlarmModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
