/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotevents.model.CreateAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateInputRequest;
import software.amazon.awssdk.services.iotevents.model.CreateInputResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteInputRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelAnalysisRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelAnalysisResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeInputRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.GetDetectorModelAnalysisResultsRequest;
import software.amazon.awssdk.services.iotevents.model.GetDetectorModelAnalysisResultsResponse;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputRoutingsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputRoutingsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputsResponse;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.StartDetectorModelAnalysisRequest;
import software.amazon.awssdk.services.iotevents.model.StartDetectorModelAnalysisResponse;
import software.amazon.awssdk.services.iotevents.model.TagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.TagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateInputRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateInputResponse;

/**
 * Service client for accessing AWS IoT Events asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions
 * when such events occur. You can use AWS IoT Events API operations to create, read, update, and delete inputs and
 * detector models, and to list their versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotEventsAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotevents";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotevents";

    /**
     * <p>
     * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when
     * the value is outside a specified range. For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an alarm model</a>
     * in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     *
     * @param createAlarmModelRequest
     * @return A Java Future containing the result of the CreateAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAlarmModelResponse> createAlarmModel(CreateAlarmModelRequest createAlarmModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when
     * the value is outside a specified range. For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an alarm model</a>
     * in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlarmModelRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAlarmModelRequest#builder()}
     * </p>
     *
     * @param createAlarmModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.CreateAlarmModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAlarmModelResponse> createAlarmModel(
            Consumer<CreateAlarmModelRequest.Builder> createAlarmModelRequest) {
        return createAlarmModel(CreateAlarmModelRequest.builder().applyMutation(createAlarmModelRequest).build());
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     *
     * @param createDetectorModelRequest
     * @return A Java Future containing the result of the CreateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDetectorModelResponse> createDetectorModel(
            CreateDetectorModelRequest createDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorModelRequest#builder()}
     * </p>
     *
     * @param createDetectorModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.CreateDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDetectorModelResponse> createDetectorModel(
            Consumer<CreateDetectorModelRequest.Builder> createDetectorModelRequest) {
        return createDetectorModel(CreateDetectorModelRequest.builder().applyMutation(createDetectorModelRequest).build());
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     *
     * @param createInputRequest
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.CreateInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(Consumer<CreateInputRequest.Builder> createInputRequest) {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * <p>
     * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This
     * action can't be undone.
     * </p>
     *
     * @param deleteAlarmModelRequest
     * @return A Java Future containing the result of the DeleteAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAlarmModelResponse> deleteAlarmModel(DeleteAlarmModelRequest deleteAlarmModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This
     * action can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlarmModelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAlarmModelRequest#builder()}
     * </p>
     *
     * @param deleteAlarmModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DeleteAlarmModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAlarmModelResponse> deleteAlarmModel(
            Consumer<DeleteAlarmModelRequest.Builder> deleteAlarmModelRequest) {
        return deleteAlarmModel(DeleteAlarmModelRequest.builder().applyMutation(deleteAlarmModelRequest).build());
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     *
     * @param deleteDetectorModelRequest
     * @return A Java Future containing the result of the DeleteDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorModelResponse> deleteDetectorModel(
            DeleteDetectorModelRequest deleteDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorModelRequest#builder()}
     * </p>
     *
     * @param deleteDetectorModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorModelResponse> deleteDetectorModel(
            Consumer<DeleteDetectorModelRequest.Builder> deleteDetectorModelRequest) {
        return deleteDetectorModel(DeleteDetectorModelRequest.builder().applyMutation(deleteDetectorModelRequest).build());
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     *
     * @param deleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DeleteInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an alarm model. If you don't specify a value for the <code>alarmModelVersion</code>
     * parameter, the latest version is returned.
     * </p>
     *
     * @param describeAlarmModelRequest
     * @return A Java Future containing the result of the DescribeAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlarmModelResponse> describeAlarmModel(DescribeAlarmModelRequest describeAlarmModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an alarm model. If you don't specify a value for the <code>alarmModelVersion</code>
     * parameter, the latest version is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlarmModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAlarmModelRequest#builder()}
     * </p>
     *
     * @param describeAlarmModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DescribeAlarmModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlarmModelResponse> describeAlarmModel(
            Consumer<DescribeAlarmModelRequest.Builder> describeAlarmModelRequest) {
        return describeAlarmModel(DescribeAlarmModelRequest.builder().applyMutation(describeAlarmModelRequest).build());
    }

    /**
     * <p>
     * Describes a detector model. If the <code>version</code> parameter is not specified, information about the latest
     * version is returned.
     * </p>
     *
     * @param describeDetectorModelRequest
     * @return A Java Future containing the result of the DescribeDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelResponse> describeDetectorModel(
            DescribeDetectorModelRequest describeDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a detector model. If the <code>version</code> parameter is not specified, information about the latest
     * version is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDetectorModelRequest#builder()}
     * </p>
     *
     * @param describeDetectorModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelResponse> describeDetectorModel(
            Consumer<DescribeDetectorModelRequest.Builder> describeDetectorModelRequest) {
        return describeDetectorModel(DescribeDetectorModelRequest.builder().applyMutation(describeDetectorModelRequest).build());
    }

    /**
     * <p>
     * Retrieves runtime information about a detector model analysis.
     * </p>
     * <note>
     * <p>
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis
     * results.
     * </p>
     * </note>
     *
     * @param describeDetectorModelAnalysisRequest
     * @return A Java Future containing the result of the DescribeDetectorModelAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModelAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModelAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelAnalysisResponse> describeDetectorModelAnalysis(
            DescribeDetectorModelAnalysisRequest describeDetectorModelAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves runtime information about a detector model analysis.
     * </p>
     * <note>
     * <p>
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorModelAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDetectorModelAnalysisRequest#builder()}
     * </p>
     *
     * @param describeDetectorModelAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelAnalysisRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDetectorModelAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeDetectorModelAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModelAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorModelAnalysisResponse> describeDetectorModelAnalysis(
            Consumer<DescribeDetectorModelAnalysisRequest.Builder> describeDetectorModelAnalysisRequest) {
        return describeDetectorModelAnalysis(DescribeDetectorModelAnalysisRequest.builder()
                .applyMutation(describeDetectorModelAnalysisRequest).build());
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     *
     * @param describeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DescribeInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest) {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current settings of the AWS IoT Events logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves one or more analysis results of the detector model.
     * </p>
     * <note>
     * <p>
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis
     * results.
     * </p>
     * </note>
     *
     * @param getDetectorModelAnalysisResultsRequest
     * @return A Java Future containing the result of the GetDetectorModelAnalysisResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.GetDetectorModelAnalysisResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/GetDetectorModelAnalysisResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorModelAnalysisResultsResponse> getDetectorModelAnalysisResults(
            GetDetectorModelAnalysisResultsRequest getDetectorModelAnalysisResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves one or more analysis results of the detector model.
     * </p>
     * <note>
     * <p>
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis
     * results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorModelAnalysisResultsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDetectorModelAnalysisResultsRequest#builder()}
     * </p>
     *
     * @param getDetectorModelAnalysisResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.GetDetectorModelAnalysisResultsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDetectorModelAnalysisResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.GetDetectorModelAnalysisResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/GetDetectorModelAnalysisResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorModelAnalysisResultsResponse> getDetectorModelAnalysisResults(
            Consumer<GetDetectorModelAnalysisResultsRequest.Builder> getDetectorModelAnalysisResultsRequest) {
        return getDetectorModelAnalysisResults(GetDetectorModelAnalysisResultsRequest.builder()
                .applyMutation(getDetectorModelAnalysisResultsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm
     * model version.
     * </p>
     *
     * @param listAlarmModelVersionsRequest
     * @return A Java Future containing the result of the ListAlarmModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListAlarmModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListAlarmModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAlarmModelVersionsResponse> listAlarmModelVersions(
            ListAlarmModelVersionsRequest listAlarmModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm
     * model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAlarmModelVersionsRequest#builder()}
     * </p>
     *
     * @param listAlarmModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListAlarmModelVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAlarmModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListAlarmModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListAlarmModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAlarmModelVersionsResponse> listAlarmModelVersions(
            Consumer<ListAlarmModelVersionsRequest.Builder> listAlarmModelVersionsRequest) {
        return listAlarmModelVersions(ListAlarmModelVersionsRequest.builder().applyMutation(listAlarmModelVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm
     * model.
     * </p>
     *
     * @param listAlarmModelsRequest
     * @return A Java Future containing the result of the ListAlarmModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListAlarmModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListAlarmModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlarmModelsResponse> listAlarmModels(ListAlarmModelsRequest listAlarmModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm
     * model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAlarmModelsRequest#builder()}
     * </p>
     *
     * @param listAlarmModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListAlarmModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAlarmModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListAlarmModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListAlarmModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlarmModelsResponse> listAlarmModels(
            Consumer<ListAlarmModelsRequest.Builder> listAlarmModelsRequest) {
        return listAlarmModels(ListAlarmModelsRequest.builder().applyMutation(listAlarmModelsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     * @return A Java Future containing the result of the ListDetectorModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelVersionsResponse> listDetectorModelVersions(
            ListDetectorModelVersionsRequest listDetectorModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDetectorModelVersionsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDetectorModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelVersionsResponse> listDetectorModelVersions(
            Consumer<ListDetectorModelVersionsRequest.Builder> listDetectorModelVersionsRequest) {
        return listDetectorModelVersions(ListDetectorModelVersionsRequest.builder()
                .applyMutation(listDetectorModelVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     *
     * @param listDetectorModelsRequest
     * @return A Java Future containing the result of the ListDetectorModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelsResponse> listDetectorModels(ListDetectorModelsRequest listDetectorModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDetectorModelsRequest#builder()}
     * </p>
     *
     * @param listDetectorModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListDetectorModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDetectorModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListDetectorModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorModelsResponse> listDetectorModels(
            Consumer<ListDetectorModelsRequest.Builder> listDetectorModelsRequest) {
        return listDetectorModels(ListDetectorModelsRequest.builder().applyMutation(listDetectorModelsRequest).build());
    }

    /**
     * <p>
     * Lists one or more input routings.
     * </p>
     *
     * @param listInputRoutingsRequest
     * @return A Java Future containing the result of the ListInputRoutings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputRoutings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputRoutings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInputRoutingsResponse> listInputRoutings(ListInputRoutingsRequest listInputRoutingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more input routings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputRoutingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputRoutingsRequest#builder()}
     * </p>
     *
     * @param listInputRoutingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListInputRoutingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInputRoutings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputRoutings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputRoutings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInputRoutingsResponse> listInputRoutings(
            Consumer<ListInputRoutingsRequest.Builder> listInputRoutingsRequest) {
        return listInputRoutings(ListInputRoutingsRequest.builder().applyMutation(listInputRoutingsRequest).build());
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     *
     * @param listInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the inputs you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListInputsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to
     * take effect. If you change the policy attached to the role you specified in the <code>roleArn</code> field (for
     * example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or updates the AWS IoT Events logging options.
     * </p>
     * <p>
     * If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to
     * take effect. If you change the policy attached to the role you specified in the <code>roleArn</code> field (for
     * example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>UnsupportedOperationException The requested operation is not supported.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(
            Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest) {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Performs an analysis of your detector model. For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Troubleshooting a
     * detector model</a> in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     *
     * @param startDetectorModelAnalysisRequest
     * @return A Java Future containing the result of the StartDetectorModelAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.StartDetectorModelAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/StartDetectorModelAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDetectorModelAnalysisResponse> startDetectorModelAnalysis(
            StartDetectorModelAnalysisRequest startDetectorModelAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs an analysis of your detector model. For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Troubleshooting a
     * detector model</a> in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDetectorModelAnalysisRequest.Builder} avoiding
     * the need to create one manually via {@link StartDetectorModelAnalysisRequest#builder()}
     * </p>
     *
     * @param startDetectorModelAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.StartDetectorModelAnalysisRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDetectorModelAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.StartDetectorModelAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/StartDetectorModelAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDetectorModelAnalysisResponse> startDetectorModelAnalysis(
            Consumer<StartDetectorModelAnalysisRequest.Builder> startDetectorModelAnalysisRequest) {
        return startDetectorModelAnalysis(StartDetectorModelAnalysisRequest.builder()
                .applyMutation(startDetectorModelAnalysisRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created
     * again as new data arrives.
     * </p>
     *
     * @param updateAlarmModelRequest
     * @return A Java Future containing the result of the UpdateAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAlarmModelResponse> updateAlarmModel(UpdateAlarmModelRequest updateAlarmModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created
     * again as new data arrives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAlarmModelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAlarmModelRequest#builder()}
     * </p>
     *
     * @param updateAlarmModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.UpdateAlarmModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAlarmModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateAlarmModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateAlarmModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAlarmModelResponse> updateAlarmModel(
            Consumer<UpdateAlarmModelRequest.Builder> updateAlarmModelRequest) {
        return updateAlarmModel(UpdateAlarmModelRequest.builder().applyMutation(updateAlarmModelRequest).build());
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     *
     * @param updateDetectorModelRequest
     * @return A Java Future containing the result of the UpdateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorModelResponse> updateDetectorModel(
            UpdateDetectorModelRequest updateDetectorModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created
     * as new inputs arrive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorModelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorModelRequest#builder()}
     * </p>
     *
     * @param updateDetectorModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDetectorModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateDetectorModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorModelResponse> updateDetectorModel(
            Consumer<UpdateDetectorModelRequest.Builder> updateDetectorModelRequest) {
        return updateDetectorModel(UpdateDetectorModelRequest.builder().applyMutation(updateDetectorModelRequest).build());
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     *
     * @param updateInputRequest
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(UpdateInputRequest updateInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotevents.model.UpdateInputRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ResourceInUseException The resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsAsyncClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    @Override
    default IotEventsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotEventsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsAsyncClient}.
     */
    static IotEventsAsyncClientBuilder builder() {
        return new DefaultIotEventsAsyncClientBuilder();
    }
}
