/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmModelResponse extends IotEventsResponse implements
        ToCopyableBuilder<DescribeAlarmModelResponse.Builder, DescribeAlarmModelResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DescribeAlarmModelResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> ALARM_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelArn").getter(getter(DescribeAlarmModelResponse::alarmModelArn))
            .setter(setter(Builder::alarmModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelArn").build()).build();

    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelVersion").getter(getter(DescribeAlarmModelResponse::alarmModelVersion))
            .setter(setter(Builder::alarmModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(DescribeAlarmModelResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeAlarmModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(DescribeAlarmModelResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(DescribeAlarmModelResponse::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelDescription").getter(getter(DescribeAlarmModelResponse::alarmModelDescription))
            .setter(setter(Builder::alarmModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeAlarmModelResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(DescribeAlarmModelResponse::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("severity").getter(getter(DescribeAlarmModelResponse::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<AlarmRule> ALARM_RULE_FIELD = SdkField.<AlarmRule> builder(MarshallingType.SDK_POJO)
            .memberName("alarmRule").getter(getter(DescribeAlarmModelResponse::alarmRule)).setter(setter(Builder::alarmRule))
            .constructor(AlarmRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRule").build()).build();

    private static final SdkField<AlarmNotification> ALARM_NOTIFICATION_FIELD = SdkField
            .<AlarmNotification> builder(MarshallingType.SDK_POJO).memberName("alarmNotification")
            .getter(getter(DescribeAlarmModelResponse::alarmNotification)).setter(setter(Builder::alarmNotification))
            .constructor(AlarmNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNotification").build()).build();

    private static final SdkField<AlarmEventActions> ALARM_EVENT_ACTIONS_FIELD = SdkField
            .<AlarmEventActions> builder(MarshallingType.SDK_POJO).memberName("alarmEventActions")
            .getter(getter(DescribeAlarmModelResponse::alarmEventActions)).setter(setter(Builder::alarmEventActions))
            .constructor(AlarmEventActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmEventActions").build()).build();

    private static final SdkField<AlarmCapabilities> ALARM_CAPABILITIES_FIELD = SdkField
            .<AlarmCapabilities> builder(MarshallingType.SDK_POJO).memberName("alarmCapabilities")
            .getter(getter(DescribeAlarmModelResponse::alarmCapabilities)).setter(setter(Builder::alarmCapabilities))
            .constructor(AlarmCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmCapabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            ALARM_MODEL_ARN_FIELD, ALARM_MODEL_VERSION_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            ALARM_MODEL_NAME_FIELD, ALARM_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, KEY_FIELD, SEVERITY_FIELD, ALARM_RULE_FIELD,
            ALARM_NOTIFICATION_FIELD, ALARM_EVENT_ACTIONS_FIELD, ALARM_CAPABILITIES_FIELD));

    private final Instant creationTime;

    private final String alarmModelArn;

    private final String alarmModelVersion;

    private final Instant lastUpdateTime;

    private final String status;

    private final String statusMessage;

    private final String alarmModelName;

    private final String alarmModelDescription;

    private final String roleArn;

    private final String key;

    private final Integer severity;

    private final AlarmRule alarmRule;

    private final AlarmNotification alarmNotification;

    private final AlarmEventActions alarmEventActions;

    private final AlarmCapabilities alarmCapabilities;

    private DescribeAlarmModelResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.alarmModelArn = builder.alarmModelArn;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.roleArn = builder.roleArn;
        this.key = builder.key;
        this.severity = builder.severity;
        this.alarmRule = builder.alarmRule;
        this.alarmNotification = builder.alarmNotification;
        this.alarmEventActions = builder.alarmEventActions;
        this.alarmCapabilities = builder.alarmCapabilities;
    }

    /**
     * <p>
     * The time the alarm model was created, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm model was created, in the Unix epoch format.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ARN of the alarm model. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the alarm model. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String alarmModelArn() {
        return alarmModelArn;
    }

    /**
     * <p>
     * The version of the alarm model.
     * </p>
     * 
     * @return The version of the alarm model.
     */
    public final String alarmModelVersion() {
        return alarmModelVersion;
    }

    /**
     * <p>
     * The time the alarm model was last updated, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm model was last updated, in the Unix epoch format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the alarm model. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to
     * a few minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model
     * information and update the alarm model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AlarmModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the alarm model. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
     *         take up to a few minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
     *         model information and update the alarm model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
     *         and try again.
     *         </p>
     *         </li>
     * @see AlarmModelVersionStatus
     */
    public final AlarmModelVersionStatus status() {
        return AlarmModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the alarm model. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to
     * a few minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model
     * information and update the alarm model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AlarmModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the alarm model. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
     *         take up to a few minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
     *         model information and update the alarm model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
     *         and try again.
     *         </p>
     *         </li>
     * @see AlarmModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains information about the status of the alarm model.
     * </p>
     * 
     * @return Contains information about the status of the alarm model.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The description of the alarm model.
     * </p>
     * 
     * @return The description of the alarm model.
     */
    public final String alarmModelDescription() {
        return alarmModelDescription;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An input attribute used as a key to create an alarm. AWS IoT Events routes <a
     * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this
     * key to the alarm.
     * </p>
     * 
     * @return An input attribute used as a key to create an alarm. AWS IoT Events routes <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated
     *         with this key to the alarm.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * A non-negative integer that reflects the severity level of the alarm.
     * </p>
     * 
     * @return A non-negative integer that reflects the severity level of the alarm.
     */
    public final Integer severity() {
        return severity;
    }

    /**
     * <p>
     * Defines when your alarm is invoked.
     * </p>
     * 
     * @return Defines when your alarm is invoked.
     */
    public final AlarmRule alarmRule() {
        return alarmRule;
    }

    /**
     * <p>
     * Contains information about one or more notification actions.
     * </p>
     * 
     * @return Contains information about one or more notification actions.
     */
    public final AlarmNotification alarmNotification() {
        return alarmNotification;
    }

    /**
     * <p>
     * Contains information about one or more alarm actions.
     * </p>
     * 
     * @return Contains information about one or more alarm actions.
     */
    public final AlarmEventActions alarmEventActions() {
        return alarmEventActions;
    }

    /**
     * <p>
     * Contains the configuration information of alarm state changes.
     * </p>
     * 
     * @return Contains the configuration information of alarm state changes.
     */
    public final AlarmCapabilities alarmCapabilities() {
        return alarmCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(alarmNotification());
        hashCode = 31 * hashCode + Objects.hashCode(alarmEventActions());
        hashCode = 31 * hashCode + Objects.hashCode(alarmCapabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmModelResponse)) {
            return false;
        }
        DescribeAlarmModelResponse other = (DescribeAlarmModelResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(alarmModelArn(), other.alarmModelArn())
                && Objects.equals(alarmModelVersion(), other.alarmModelVersion())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelDescription(), other.alarmModelDescription())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(key(), other.key())
                && Objects.equals(severity(), other.severity()) && Objects.equals(alarmRule(), other.alarmRule())
                && Objects.equals(alarmNotification(), other.alarmNotification())
                && Objects.equals(alarmEventActions(), other.alarmEventActions())
                && Objects.equals(alarmCapabilities(), other.alarmCapabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmModelResponse").add("CreationTime", creationTime())
                .add("AlarmModelArn", alarmModelArn()).add("AlarmModelVersion", alarmModelVersion())
                .add("LastUpdateTime", lastUpdateTime()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("AlarmModelName", alarmModelName()).add("AlarmModelDescription", alarmModelDescription())
                .add("RoleArn", roleArn()).add("Key", key()).add("Severity", severity()).add("AlarmRule", alarmRule())
                .add("AlarmNotification", alarmNotification()).add("AlarmEventActions", alarmEventActions())
                .add("AlarmCapabilities", alarmCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "alarmModelArn":
            return Optional.ofNullable(clazz.cast(alarmModelArn()));
        case "alarmModelVersion":
            return Optional.ofNullable(clazz.cast(alarmModelVersion()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelDescription":
            return Optional.ofNullable(clazz.cast(alarmModelDescription()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "alarmRule":
            return Optional.ofNullable(clazz.cast(alarmRule()));
        case "alarmNotification":
            return Optional.ofNullable(clazz.cast(alarmNotification()));
        case "alarmEventActions":
            return Optional.ofNullable(clazz.cast(alarmEventActions()));
        case "alarmCapabilities":
            return Optional.ofNullable(clazz.cast(alarmCapabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmModelResponse, T> g) {
        return obj -> g.apply((DescribeAlarmModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmModelResponse> {
        /**
         * <p>
         * The time the alarm model was created, in the Unix epoch format.
         * </p>
         * 
         * @param creationTime
         *        The time the alarm model was created, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ARN of the alarm model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param alarmModelArn
         *        The ARN of the alarm model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelArn(String alarmModelArn);

        /**
         * <p>
         * The version of the alarm model.
         * </p>
         * 
         * @param alarmModelVersion
         *        The version of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersion(String alarmModelVersion);

        /**
         * <p>
         * The time the alarm model was last updated, in the Unix epoch format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the alarm model was last updated, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the alarm model. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take
         * up to a few minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
         * model information and update the alarm model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and
         * try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the alarm model. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
         *        take up to a few minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your
         *        alarm model information and update the alarm model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model
         *        information and try again.
         *        </p>
         *        </li>
         * @see AlarmModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the alarm model. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take
         * up to a few minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
         * model information and update the alarm model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and
         * try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the alarm model. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
         *        take up to a few minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your
         *        alarm model information and update the alarm model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model
         *        information and try again.
         *        </p>
         *        </li>
         * @see AlarmModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmModelVersionStatus
         */
        Builder status(AlarmModelVersionStatus status);

        /**
         * <p>
         * Contains information about the status of the alarm model.
         * </p>
         * 
         * @param statusMessage
         *        Contains information about the status of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The description of the alarm model.
         * </p>
         * 
         * @param alarmModelDescription
         *        The description of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelDescription(String alarmModelDescription);

        /**
         * <p>
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An input attribute used as a key to create an alarm. AWS IoT Events routes <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with
         * this key to the alarm.
         * </p>
         * 
         * @param key
         *        An input attribute used as a key to create an alarm. AWS IoT Events routes <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated
         *        with this key to the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A non-negative integer that reflects the severity level of the alarm.
         * </p>
         * 
         * @param severity
         *        A non-negative integer that reflects the severity level of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Integer severity);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * 
         * @param alarmRule
         *        Defines when your alarm is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRule(AlarmRule alarmRule);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmRule.Builder} avoiding the need to
         * create one manually via {@link AlarmRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmRule.Builder#build()} is called immediately and its result
         * is passed to {@link #alarmRule(AlarmRule)}.
         * 
         * @param alarmRule
         *        a consumer that will call methods on {@link AlarmRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmRule(AlarmRule)
         */
        default Builder alarmRule(Consumer<AlarmRule.Builder> alarmRule) {
            return alarmRule(AlarmRule.builder().applyMutation(alarmRule).build());
        }

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * 
         * @param alarmNotification
         *        Contains information about one or more notification actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNotification(AlarmNotification alarmNotification);

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmNotification.Builder} avoiding the
         * need to create one manually via {@link AlarmNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmNotification.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmNotification(AlarmNotification)}.
         * 
         * @param alarmNotification
         *        a consumer that will call methods on {@link AlarmNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmNotification(AlarmNotification)
         */
        default Builder alarmNotification(Consumer<AlarmNotification.Builder> alarmNotification) {
            return alarmNotification(AlarmNotification.builder().applyMutation(alarmNotification).build());
        }

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * 
         * @param alarmEventActions
         *        Contains information about one or more alarm actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmEventActions(AlarmEventActions alarmEventActions);

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmEventActions.Builder} avoiding the
         * need to create one manually via {@link AlarmEventActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmEventActions.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmEventActions(AlarmEventActions)}.
         * 
         * @param alarmEventActions
         *        a consumer that will call methods on {@link AlarmEventActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmEventActions(AlarmEventActions)
         */
        default Builder alarmEventActions(Consumer<AlarmEventActions.Builder> alarmEventActions) {
            return alarmEventActions(AlarmEventActions.builder().applyMutation(alarmEventActions).build());
        }

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * 
         * @param alarmCapabilities
         *        Contains the configuration information of alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmCapabilities(AlarmCapabilities alarmCapabilities);

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmCapabilities.Builder} avoiding the
         * need to create one manually via {@link AlarmCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmCapabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmCapabilities(AlarmCapabilities)}.
         * 
         * @param alarmCapabilities
         *        a consumer that will call methods on {@link AlarmCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmCapabilities(AlarmCapabilities)
         */
        default Builder alarmCapabilities(Consumer<AlarmCapabilities.Builder> alarmCapabilities) {
            return alarmCapabilities(AlarmCapabilities.builder().applyMutation(alarmCapabilities).build());
        }
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String alarmModelArn;

        private String alarmModelVersion;

        private Instant lastUpdateTime;

        private String status;

        private String statusMessage;

        private String alarmModelName;

        private String alarmModelDescription;

        private String roleArn;

        private String key;

        private Integer severity;

        private AlarmRule alarmRule;

        private AlarmNotification alarmNotification;

        private AlarmEventActions alarmEventActions;

        private AlarmCapabilities alarmCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmModelResponse model) {
            super(model);
            creationTime(model.creationTime);
            alarmModelArn(model.alarmModelArn);
            alarmModelVersion(model.alarmModelVersion);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
            statusMessage(model.statusMessage);
            alarmModelName(model.alarmModelName);
            alarmModelDescription(model.alarmModelDescription);
            roleArn(model.roleArn);
            key(model.key);
            severity(model.severity);
            alarmRule(model.alarmRule);
            alarmNotification(model.alarmNotification);
            alarmEventActions(model.alarmEventActions);
            alarmCapabilities(model.alarmCapabilities);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlarmModelArn() {
            return alarmModelArn;
        }

        public final void setAlarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
        }

        @Override
        public final Builder alarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
            return this;
        }

        public final String getAlarmModelVersion() {
            return alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelDescription() {
            return alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Integer getSeverity() {
            return severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final AlarmRule.Builder getAlarmRule() {
            return alarmRule != null ? alarmRule.toBuilder() : null;
        }

        public final void setAlarmRule(AlarmRule.BuilderImpl alarmRule) {
            this.alarmRule = alarmRule != null ? alarmRule.build() : null;
        }

        @Override
        public final Builder alarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final AlarmNotification.Builder getAlarmNotification() {
            return alarmNotification != null ? alarmNotification.toBuilder() : null;
        }

        public final void setAlarmNotification(AlarmNotification.BuilderImpl alarmNotification) {
            this.alarmNotification = alarmNotification != null ? alarmNotification.build() : null;
        }

        @Override
        public final Builder alarmNotification(AlarmNotification alarmNotification) {
            this.alarmNotification = alarmNotification;
            return this;
        }

        public final AlarmEventActions.Builder getAlarmEventActions() {
            return alarmEventActions != null ? alarmEventActions.toBuilder() : null;
        }

        public final void setAlarmEventActions(AlarmEventActions.BuilderImpl alarmEventActions) {
            this.alarmEventActions = alarmEventActions != null ? alarmEventActions.build() : null;
        }

        @Override
        public final Builder alarmEventActions(AlarmEventActions alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        public final AlarmCapabilities.Builder getAlarmCapabilities() {
            return alarmCapabilities != null ? alarmCapabilities.toBuilder() : null;
        }

        public final void setAlarmCapabilities(AlarmCapabilities.BuilderImpl alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities != null ? alarmCapabilities.build() : null;
        }

        @Override
        public final Builder alarmCapabilities(AlarmCapabilities alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        @Override
        public DescribeAlarmModelResponse build() {
            return new DescribeAlarmModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
