/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about one or more notification actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmNotification.Builder, AlarmNotification> {
    private static final SdkField<List<NotificationAction>> NOTIFICATION_ACTIONS_FIELD = SdkField
            .<List<NotificationAction>> builder(MarshallingType.LIST)
            .memberName("notificationActions")
            .getter(getter(AlarmNotification::notificationActions))
            .setter(setter(Builder::notificationActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<NotificationAction> notificationActions;

    private AlarmNotification(BuilderImpl builder) {
        this.notificationActions = builder.notificationActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationActions() {
        return notificationActions != null && !(notificationActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on
     * this alarm model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationActions} method.
     * </p>
     * 
     * @return Contains the notification settings of an alarm model. The settings apply to all alarms that were created
     *         based on this alarm model.
     */
    public final List<NotificationAction> notificationActions() {
        return notificationActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationActions() ? notificationActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmNotification)) {
            return false;
        }
        AlarmNotification other = (AlarmNotification) obj;
        return hasNotificationActions() == other.hasNotificationActions()
                && Objects.equals(notificationActions(), other.notificationActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmNotification")
                .add("NotificationActions", hasNotificationActions() ? notificationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationActions":
            return Optional.ofNullable(clazz.cast(notificationActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmNotification, T> g) {
        return obj -> g.apply((AlarmNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmNotification> {
        /**
         * <p>
         * Contains the notification settings of an alarm model. The settings apply to all alarms that were created
         * based on this alarm model.
         * </p>
         * 
         * @param notificationActions
         *        Contains the notification settings of an alarm model. The settings apply to all alarms that were
         *        created based on this alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationActions(Collection<NotificationAction> notificationActions);

        /**
         * <p>
         * Contains the notification settings of an alarm model. The settings apply to all alarms that were created
         * based on this alarm model.
         * </p>
         * 
         * @param notificationActions
         *        Contains the notification settings of an alarm model. The settings apply to all alarms that were
         *        created based on this alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationActions(NotificationAction... notificationActions);

        /**
         * <p>
         * Contains the notification settings of an alarm model. The settings apply to all alarms that were created
         * based on this alarm model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.NotificationAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotevents.model.NotificationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.NotificationAction.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationActions(List<NotificationAction>)}.
         * 
         * @param notificationActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.NotificationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationActions(java.util.Collection<NotificationAction>)
         */
        Builder notificationActions(Consumer<NotificationAction.Builder>... notificationActions);
    }

    static final class BuilderImpl implements Builder {
        private List<NotificationAction> notificationActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmNotification model) {
            notificationActions(model.notificationActions);
        }

        public final List<NotificationAction.Builder> getNotificationActions() {
            List<NotificationAction.Builder> result = NotificationActionsCopier.copyToBuilder(this.notificationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationActions(Collection<NotificationAction.BuilderImpl> notificationActions) {
            this.notificationActions = NotificationActionsCopier.copyFromBuilder(notificationActions);
        }

        @Override
        public final Builder notificationActions(Collection<NotificationAction> notificationActions) {
            this.notificationActions = NotificationActionsCopier.copy(notificationActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationActions(NotificationAction... notificationActions) {
            notificationActions(Arrays.asList(notificationActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationActions(Consumer<NotificationAction.Builder>... notificationActions) {
            notificationActions(Stream.of(notificationActions).map(c -> NotificationAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AlarmNotification build() {
            return new AlarmNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
