/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a
 * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided
 * by AWS IoT Events</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationTargetActions implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationTargetActions.Builder, NotificationTargetActions> {
    private static final SdkField<LambdaAction> LAMBDA_ACTION_FIELD = SdkField.<LambdaAction> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaAction").getter(getter(NotificationTargetActions::lambdaAction))
            .setter(setter(Builder::lambdaAction)).constructor(LambdaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaAction lambdaAction;

    private NotificationTargetActions(BuilderImpl builder) {
        this.lambdaAction = builder.lambdaAction;
    }

    /**
     * Returns the value of the LambdaAction property for this object.
     * 
     * @return The value of the LambdaAction property for this object.
     */
    public final LambdaAction lambdaAction() {
        return lambdaAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationTargetActions)) {
            return false;
        }
        NotificationTargetActions other = (NotificationTargetActions) obj;
        return Objects.equals(lambdaAction(), other.lambdaAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationTargetActions").add("LambdaAction", lambdaAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaAction":
            return Optional.ofNullable(clazz.cast(lambdaAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationTargetActions, T> g) {
        return obj -> g.apply((NotificationTargetActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationTargetActions> {
        /**
         * Sets the value of the LambdaAction property for this object.
         *
         * @param lambdaAction
         *        The new value for the LambdaAction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAction(LambdaAction lambdaAction);

        /**
         * Sets the value of the LambdaAction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LambdaAction.Builder} avoiding the need
         * to create one manually via {@link LambdaAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaAction(LambdaAction)}.
         * 
         * @param lambdaAction
         *        a consumer that will call methods on {@link LambdaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAction(LambdaAction)
         */
        default Builder lambdaAction(Consumer<LambdaAction.Builder> lambdaAction) {
            return lambdaAction(LambdaAction.builder().applyMutation(lambdaAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaAction lambdaAction;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationTargetActions model) {
            lambdaAction(model.lambdaAction);
        }

        public final LambdaAction.Builder getLambdaAction() {
            return lambdaAction != null ? lambdaAction.toBuilder() : null;
        }

        public final void setLambdaAction(LambdaAction.BuilderImpl lambdaAction) {
            this.lambdaAction = lambdaAction != null ? lambdaAction.build() : null;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        @Override
        public NotificationTargetActions build() {
            return new NotificationTargetActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
