/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of one or more recipients who receive the emails.
 * </p>
 * <important>
 * <p>
 * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive
 * emails to your AWS SSO store</a>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailRecipients implements SdkPojo, Serializable, ToCopyableBuilder<EmailRecipients.Builder, EmailRecipients> {
    private static final SdkField<List<RecipientDetail>> TO_FIELD = SdkField
            .<List<RecipientDetail>> builder(MarshallingType.LIST)
            .memberName("to")
            .getter(getter(EmailRecipients::to))
            .setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecipientDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecipientDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RecipientDetail> to;

    private EmailRecipients(BuilderImpl builder) {
        this.to = builder.to;
    }

    /**
     * For responses, this returns true if the service returned a value for the To property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTo() {
        return to != null && !(to instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTo} method.
     * </p>
     * 
     * @return Specifies one or more recipients who receive the email.
     */
    public final List<RecipientDetail> to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTo() ? to() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailRecipients)) {
            return false;
        }
        EmailRecipients other = (EmailRecipients) obj;
        return hasTo() == other.hasTo() && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailRecipients").add("To", hasTo() ? to() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailRecipients, T> g) {
        return obj -> g.apply((EmailRecipients) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailRecipients> {
        /**
         * <p>
         * Specifies one or more recipients who receive the email.
         * </p>
         * 
         * @param to
         *        Specifies one or more recipients who receive the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Collection<RecipientDetail> to);

        /**
         * <p>
         * Specifies one or more recipients who receive the email.
         * </p>
         * 
         * @param to
         *        Specifies one or more recipients who receive the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(RecipientDetail... to);

        /**
         * <p>
         * Specifies one or more recipients who receive the email.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #to(List<RecipientDetail>)}.
         * 
         * @param to
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.RecipientDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #to(java.util.Collection<RecipientDetail>)
         */
        Builder to(Consumer<RecipientDetail.Builder>... to);
    }

    static final class BuilderImpl implements Builder {
        private List<RecipientDetail> to = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailRecipients model) {
            to(model.to);
        }

        public final List<RecipientDetail.Builder> getTo() {
            List<RecipientDetail.Builder> result = RecipientDetailsCopier.copyToBuilder(this.to);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTo(Collection<RecipientDetail.BuilderImpl> to) {
            this.to = RecipientDetailsCopier.copyFromBuilder(to);
        }

        @Override
        public final Builder to(Collection<RecipientDetail> to) {
            this.to = RecipientDetailsCopier.copy(to);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder to(RecipientDetail... to) {
            to(Arrays.asList(to));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder to(Consumer<RecipientDetail.Builder>... to) {
            to(Stream.of(to).map(c -> RecipientDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EmailRecipients build() {
            return new EmailRecipients(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
