/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputResponse extends IotEventsResponse implements
        ToCopyableBuilder<DescribeInputResponse.Builder, DescribeInputResponse> {
    private static final SdkField<Input> INPUT_FIELD = SdkField.<Input> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(DescribeInputResponse::input)).setter(setter(Builder::input)).constructor(Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD));

    private final Input input;

    private DescribeInputResponse(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
    }

    /**
     * <p>
     * Information about the input.
     * </p>
     * 
     * @return Information about the input.
     */
    public final Input input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputResponse)) {
            return false;
        }
        DescribeInputResponse other = (DescribeInputResponse) obj;
        return Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInputResponse").add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputResponse, T> g) {
        return obj -> g.apply((DescribeInputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInputResponse> {
        /**
         * <p>
         * Information about the input.
         * </p>
         * 
         * @param input
         *        Information about the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * <p>
         * Information about the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link Input.Builder} avoiding the need to
         * create one manually via {@link Input#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().applyMutation(input).build());
        }
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputResponse model) {
            super(model);
            input(model.input);
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        @Override
        public DescribeInputResponse build() {
            return new DescribeInputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
