/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.endpoints.internal;

import java.io.InputStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.services.iotevents.endpoints.internal.PartitionDataProvider;
import software.amazon.awssdk.services.iotevents.endpoints.internal.Partitions;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Lazy;

@SdkInternalApi
public final class DefaultPartitionDataProvider
implements PartitionDataProvider {
    private static final String DEFAULT_PARTITIONS_DATA = "partitions.json";
    private static final Lazy<Partitions> PARTITIONS = new Lazy(DefaultPartitionDataProvider::doLoadPartitions);

    @Override
    public Partitions loadPartitions() {
        return (Partitions)PARTITIONS.getValue();
    }

    private static Partitions doLoadPartitions() {
        InputStream json = DefaultPartitionDataProvider.class.getResourceAsStream(DEFAULT_PARTITIONS_DATA);
        try {
            Partitions partitions = Partitions.fromNode(JsonNode.parser().parse(json));
            return partitions;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)json, null);
        }
    }
}

