/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileFormatType {
    JSON("JSON"),
    PARQUET("PARQUET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileFormatType> VALUE_MAP;
    private final String value;

    private FileFormatType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileFormatType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileFormatType> knownValues() {
        EnumSet<FileFormatType> knownValues = EnumSet.allOf(FileFormatType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileFormatType.class, FileFormatType::toString);
    }
}

