/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeManagedJobTemplateResponse extends IotResponse implements
        ToCopyableBuilder<DescribeManagedJobTemplateResponse.Builder, DescribeManagedJobTemplateResponse> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(DescribeManagedJobTemplateResponse::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateArn").getter(getter(DescribeManagedJobTemplateResponse::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeManagedJobTemplateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateVersion").getter(getter(DescribeManagedJobTemplateResponse::templateVersion))
            .setter(setter(Builder::templateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersion").build()).build();

    private static final SdkField<List<String>> ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("environments")
            .getter(getter(DescribeManagedJobTemplateResponse::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentParameter>> DOCUMENT_PARAMETERS_FIELD = SdkField
            .<List<DocumentParameter>> builder(MarshallingType.LIST)
            .memberName("documentParameters")
            .getter(getter(DescribeManagedJobTemplateResponse::documentParameters))
            .setter(setter(Builder::documentParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("document").getter(getter(DescribeManagedJobTemplateResponse::document))
            .setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_ARN_FIELD, DESCRIPTION_FIELD, TEMPLATE_VERSION_FIELD, ENVIRONMENTS_FIELD, DOCUMENT_PARAMETERS_FIELD,
            DOCUMENT_FIELD));

    private final String templateName;

    private final String templateArn;

    private final String description;

    private final String templateVersion;

    private final List<String> environments;

    private final List<DocumentParameter> documentParameters;

    private final String document;

    private DescribeManagedJobTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateArn = builder.templateArn;
        this.description = builder.description;
        this.templateVersion = builder.templateVersion;
        this.environments = builder.environments;
        this.documentParameters = builder.documentParameters;
        this.document = builder.document;
    }

    /**
     * <p>
     * The unique name of a managed template, such as <code>AWS-Reboot</code>.
     * </p>
     * 
     * @return The unique name of a managed template, such as <code>AWS-Reboot</code>.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the managed template.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the managed template.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The unique description of a managed template.
     * </p>
     * 
     * @return The unique description of a managed template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version for a managed template.
     * </p>
     * 
     * @return The version for a managed template.
     */
    public final String templateVersion() {
        return templateVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of environments that are supported with the managed job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironments} method.
     * </p>
     * 
     * @return A list of environments that are supported with the managed job template.
     */
    public final List<String> environments() {
        return environments;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentParameters() {
        return documentParameters != null && !(documentParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed
     * template.
     * </p>
     * <note>
     * <p>
     * <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed templates.
     * This parameter can't be used with custom job templates or to create jobs from them.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentParameters} method.
     * </p>
     * 
     * @return A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a
     *         managed template.</p> <note>
     *         <p>
     *         <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
     *         templates. This parameter can't be used with custom job templates or to create jobs from them.
     *         </p>
     */
    public final List<DocumentParameter> documentParameters() {
        return documentParameters;
    }

    /**
     * <p>
     * The document schema for a managed job template.
     * </p>
     * 
     * @return The document schema for a managed job template.
     */
    public final String document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentParameters() ? documentParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedJobTemplateResponse)) {
            return false;
        }
        DescribeManagedJobTemplateResponse other = (DescribeManagedJobTemplateResponse) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateArn(), other.templateArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(templateVersion(), other.templateVersion()) && hasEnvironments() == other.hasEnvironments()
                && Objects.equals(environments(), other.environments())
                && hasDocumentParameters() == other.hasDocumentParameters()
                && Objects.equals(documentParameters(), other.documentParameters())
                && Objects.equals(document(), other.document());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeManagedJobTemplateResponse").add("TemplateName", templateName())
                .add("TemplateArn", templateArn()).add("Description", description()).add("TemplateVersion", templateVersion())
                .add("Environments", hasEnvironments() ? environments() : null)
                .add("DocumentParameters", hasDocumentParameters() ? documentParameters() : null).add("Document", document())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateVersion":
            return Optional.ofNullable(clazz.cast(templateVersion()));
        case "environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "documentParameters":
            return Optional.ofNullable(clazz.cast(documentParameters()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedJobTemplateResponse, T> g) {
        return obj -> g.apply((DescribeManagedJobTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeManagedJobTemplateResponse> {
        /**
         * <p>
         * The unique name of a managed template, such as <code>AWS-Reboot</code>.
         * </p>
         * 
         * @param templateName
         *        The unique name of a managed template, such as <code>AWS-Reboot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the managed template.
         * </p>
         * 
         * @param templateArn
         *        The unique Amazon Resource Name (ARN) of the managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The unique description of a managed template.
         * </p>
         * 
         * @param description
         *        The unique description of a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version for a managed template.
         * </p>
         * 
         * @param templateVersion
         *        The version for a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersion(String templateVersion);

        /**
         * <p>
         * A list of environments that are supported with the managed job template.
         * </p>
         * 
         * @param environments
         *        A list of environments that are supported with the managed job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<String> environments);

        /**
         * <p>
         * A list of environments that are supported with the managed job template.
         * </p>
         * 
         * @param environments
         *        A list of environments that are supported with the managed job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(String... environments);

        /**
         * <p>
         * A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed
         * template.
         * </p>
         * <note>
         * <p>
         * <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
         * templates. This parameter can't be used with custom job templates or to create jobs from them.
         * </p>
         * </note>
         * 
         * @param documentParameters
         *        A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a
         *        managed template.</p> <note>
         *        <p>
         *        <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
         *        templates. This parameter can't be used with custom job templates or to create jobs from them.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentParameters(Collection<DocumentParameter> documentParameters);

        /**
         * <p>
         * A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed
         * template.
         * </p>
         * <note>
         * <p>
         * <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
         * templates. This parameter can't be used with custom job templates or to create jobs from them.
         * </p>
         * </note>
         * 
         * @param documentParameters
         *        A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a
         *        managed template.</p> <note>
         *        <p>
         *        <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
         *        templates. This parameter can't be used with custom job templates or to create jobs from them.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentParameters(DocumentParameter... documentParameters);

        /**
         * <p>
         * A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed
         * template.
         * </p>
         * <note>
         * <p>
         * <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed
         * templates. This parameter can't be used with custom job templates or to create jobs from them.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.DocumentParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.DocumentParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.DocumentParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #documentParameters(List<DocumentParameter>)}.
         * 
         * @param documentParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.DocumentParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentParameters(java.util.Collection<DocumentParameter>)
         */
        Builder documentParameters(Consumer<DocumentParameter.Builder>... documentParameters);

        /**
         * <p>
         * The document schema for a managed job template.
         * </p>
         * 
         * @param document
         *        The document schema for a managed job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String templateName;

        private String templateArn;

        private String description;

        private String templateVersion;

        private List<String> environments = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentParameter> documentParameters = DefaultSdkAutoConstructList.getInstance();

        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedJobTemplateResponse model) {
            super(model);
            templateName(model.templateName);
            templateArn(model.templateArn);
            description(model.description);
            templateVersion(model.templateVersion);
            environments(model.environments);
            documentParameters(model.documentParameters);
            document(model.document);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateVersion() {
            return templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        public final Collection<String> getEnvironments() {
            if (environments instanceof SdkAutoConstructList) {
                return null;
            }
            return environments;
        }

        public final void setEnvironments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
        }

        @Override
        public final Builder environments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(String... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        public final List<DocumentParameter.Builder> getDocumentParameters() {
            List<DocumentParameter.Builder> result = DocumentParametersCopier.copyToBuilder(this.documentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentParameters(Collection<DocumentParameter.BuilderImpl> documentParameters) {
            this.documentParameters = DocumentParametersCopier.copyFromBuilder(documentParameters);
        }

        @Override
        public final Builder documentParameters(Collection<DocumentParameter> documentParameters) {
            this.documentParameters = DocumentParametersCopier.copy(documentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentParameters(DocumentParameter... documentParameters) {
            documentParameters(Arrays.asList(documentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentParameters(Consumer<DocumentParameter.Builder>... documentParameters) {
            documentParameters(Stream.of(documentParameters).map(c -> DocumentParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDocument() {
            return document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        @Override
        public DescribeManagedJobTemplateResponse build() {
            return new DescribeManagedJobTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
