/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.services.honeycode.model.ResultSet;
import software.amazon.awssdk.services.honeycode.model.ResultSetMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScreenDataResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, GetScreenDataResponse> {
    private static final SdkField<Map<String, ResultSet>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("results").getter(GetScreenDataResponse.getter(GetScreenDataResponse::results)).setter(GetScreenDataResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("workbookCursor").getter(GetScreenDataResponse.getter(GetScreenDataResponse::workbookCursor)).setter(GetScreenDataResponse.setter(Builder::workbookCursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetScreenDataResponse.getter(GetScreenDataResponse::nextToken)).setter(GetScreenDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, WORKBOOK_CURSOR_FIELD, NEXT_TOKEN_FIELD));
    private final Map<String, ResultSet> results;
    private final Long workbookCursor;
    private final String nextToken;

    private GetScreenDataResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.workbookCursor = builder.workbookCursor;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructMap);
    }

    public final Map<String, ResultSet> results() {
        return this.results;
    }

    public final Long workbookCursor() {
        return this.workbookCursor;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookCursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScreenDataResponse)) {
            return false;
        }
        GetScreenDataResponse other = (GetScreenDataResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.workbookCursor(), other.workbookCursor()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetScreenDataResponse").add("Results", (Object)(this.results() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkbookCursor", (Object)this.workbookCursor()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "workbookCursor": {
                return Optional.ofNullable(clazz.cast(this.workbookCursor()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScreenDataResponse, T> g) {
        return obj -> g.apply((GetScreenDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private Map<String, ResultSet> results = DefaultSdkAutoConstructMap.getInstance();
        private Long workbookCursor;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScreenDataResponse model) {
            super(model);
            this.results(model.results);
            this.workbookCursor(model.workbookCursor);
            this.nextToken(model.nextToken);
        }

        public final Map<String, ResultSet.Builder> getResults() {
            Map<String, ResultSet.Builder> result = ResultSetMapCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResults(Map<String, ResultSet.BuilderImpl> results) {
            this.results = ResultSetMapCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Map<String, ResultSet> results) {
            this.results = ResultSetMapCopier.copy(results);
            return this;
        }

        public final Long getWorkbookCursor() {
            return this.workbookCursor;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetScreenDataResponse build() {
            return new GetScreenDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScreenDataResponse> {
        public Builder results(Map<String, ResultSet> var1);

        public Builder workbookCursor(Long var1);

        public Builder nextToken(String var1);
    }
}

