/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeAsyncClient;
import software.amazon.awssdk.services.honeycode.internal.UserAgentUtils;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.TableRow;

public class ListTableRowsPublisher
implements SdkPublisher<ListTableRowsResponse> {
    private final HoneycodeAsyncClient client;
    private final ListTableRowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableRowsPublisher(HoneycodeAsyncClient client, ListTableRowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableRowsPublisher(HoneycodeAsyncClient client, ListTableRowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableRowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableRowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableRow> rows() {
        Function<ListTableRowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableRowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableRowsResponseFetcher
    implements AsyncPageFetcher<ListTableRowsResponse> {
        private ListTableRowsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableRowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableRowsResponse> nextPage(ListTableRowsResponse previousPage) {
            if (previousPage == null) {
                return ListTableRowsPublisher.this.client.listTableRows(ListTableRowsPublisher.this.firstRequest);
            }
            return ListTableRowsPublisher.this.client.listTableRows((ListTableRowsRequest)((Object)ListTableRowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

