/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.ImportDataSource;
import software.amazon.awssdk.services.honeycode.model.ImportOptions;
import software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTableDataImportJobRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, StartTableDataImportJobRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::workbookId)).setter(StartTableDataImportJobRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<ImportDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::dataSource)).setter(StartTableDataImportJobRequest.setter(Builder::dataSource)).constructor(ImportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataFormat").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::dataFormatAsString)).setter(StartTableDataImportJobRequest.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFormat").build()}).build();
    private static final SdkField<String> DESTINATION_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationTableId").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::destinationTableId)).setter(StartTableDataImportJobRequest.setter(Builder::destinationTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importOptions").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::importOptions)).setter(StartTableDataImportJobRequest.setter(Builder::importOptions)).constructor(ImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartTableDataImportJobRequest.getter(StartTableDataImportJobRequest::clientRequestToken)).setter(StartTableDataImportJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, DATA_SOURCE_FIELD, DATA_FORMAT_FIELD, DESTINATION_TABLE_ID_FIELD, IMPORT_OPTIONS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final ImportDataSource dataSource;
    private final String dataFormat;
    private final String destinationTableId;
    private final ImportOptions importOptions;
    private final String clientRequestToken;

    private StartTableDataImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.dataSource = builder.dataSource;
        this.dataFormat = builder.dataFormat;
        this.destinationTableId = builder.destinationTableId;
        this.importOptions = builder.importOptions;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final ImportDataSource dataSource() {
        return this.dataSource;
    }

    public final ImportSourceDataFormat dataFormat() {
        return ImportSourceDataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String destinationTableId() {
        return this.destinationTableId;
    }

    public final ImportOptions importOptions() {
        return this.importOptions;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTableDataImportJobRequest)) {
            return false;
        }
        StartTableDataImportJobRequest other = (StartTableDataImportJobRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.destinationTableId(), other.destinationTableId()) && Objects.equals(this.importOptions(), other.importOptions()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartTableDataImportJobRequest").add("WorkbookId", (Object)this.workbookId()).add("DataSource", (Object)this.dataSource()).add("DataFormat", (Object)this.dataFormatAsString()).add("DestinationTableId", (Object)this.destinationTableId()).add("ImportOptions", (Object)this.importOptions()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "dataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "destinationTableId": {
                return Optional.ofNullable(clazz.cast(this.destinationTableId()));
            }
            case "importOptions": {
                return Optional.ofNullable(clazz.cast(this.importOptions()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTableDataImportJobRequest, T> g) {
        return obj -> g.apply((StartTableDataImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private ImportDataSource dataSource;
        private String dataFormat;
        private String destinationTableId;
        private ImportOptions importOptions;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTableDataImportJobRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.dataSource(model.dataSource);
            this.dataFormat(model.dataFormat);
            this.destinationTableId(model.destinationTableId);
            this.importOptions(model.importOptions);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final ImportDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(ImportDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ImportDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(ImportSourceDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getDestinationTableId() {
            return this.destinationTableId;
        }

        public final void setDestinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
        }

        @Override
        public final Builder destinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return this.importOptions != null ? this.importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTableDataImportJobRequest build() {
            return new StartTableDataImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTableDataImportJobRequest> {
        public Builder workbookId(String var1);

        public Builder dataSource(ImportDataSource var1);

        default public Builder dataSource(Consumer<ImportDataSource.Builder> dataSource) {
            return this.dataSource((ImportDataSource)((ImportDataSource.Builder)ImportDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder dataFormat(String var1);

        public Builder dataFormat(ImportSourceDataFormat var1);

        public Builder destinationTableId(String var1);

        public Builder importOptions(ImportOptions var1);

        default public Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return this.importOptions((ImportOptions)((ImportOptions.Builder)ImportOptions.builder().applyMutation(importOptions)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

