/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about criteria used to filter resources before triggering malware scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanResourceCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ScanResourceCriteria.Builder, ScanResourceCriteria> {
    private static final SdkField<Map<String, ScanCondition>> INCLUDE_FIELD = SdkField
            .<Map<String, ScanCondition>> builder(MarshallingType.MAP)
            .memberName("Include")
            .getter(getter(ScanResourceCriteria::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ScanCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ScanCondition>> EXCLUDE_FIELD = SdkField
            .<Map<String, ScanCondition>> builder(MarshallingType.MAP)
            .memberName("Exclude")
            .getter(getter(ScanResourceCriteria::excludeAsStrings))
            .setter(setter(Builder::excludeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclude").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ScanCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, EXCLUDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, ScanCondition> include;

    private final Map<String, ScanCondition> exclude;

    private ScanResourceCriteria(BuilderImpl builder) {
        this.include = builder.include;
        this.exclude = builder.exclude;
    }

    /**
     * <p>
     * Represents condition that when matched will allow a malware scan for a certain resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Represents condition that when matched will allow a malware scan for a certain resource.
     */
    public final Map<ScanCriterionKey, ScanCondition> include() {
        return ScanCriterionCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents condition that when matched will allow a malware scan for a certain resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Represents condition that when matched will allow a malware scan for a certain resource.
     */
    public final Map<String, ScanCondition> includeAsStrings() {
        return include;
    }

    /**
     * <p>
     * Represents condition that when matched will prevent a malware scan for a certain resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclude} method.
     * </p>
     * 
     * @return Represents condition that when matched will prevent a malware scan for a certain resource.
     */
    public final Map<ScanCriterionKey, ScanCondition> exclude() {
        return ScanCriterionCopier.copyStringToEnum(exclude);
    }

    /**
     * For responses, this returns true if the service returned a value for the Exclude property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExclude() {
        return exclude != null && !(exclude instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents condition that when matched will prevent a malware scan for a certain resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclude} method.
     * </p>
     * 
     * @return Represents condition that when matched will prevent a malware scan for a certain resource.
     */
    public final Map<String, ScanCondition> excludeAsStrings() {
        return exclude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclude() ? excludeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResourceCriteria)) {
            return false;
        }
        ScanResourceCriteria other = (ScanResourceCriteria) obj;
        return hasInclude() == other.hasInclude() && Objects.equals(includeAsStrings(), other.includeAsStrings())
                && hasExclude() == other.hasExclude() && Objects.equals(excludeAsStrings(), other.excludeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanResourceCriteria").add("Include", hasInclude() ? includeAsStrings() : null)
                .add("Exclude", hasExclude() ? excludeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(excludeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanResourceCriteria, T> g) {
        return obj -> g.apply((ScanResourceCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanResourceCriteria> {
        /**
         * <p>
         * Represents condition that when matched will allow a malware scan for a certain resource.
         * </p>
         * 
         * @param include
         *        Represents condition that when matched will allow a malware scan for a certain resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Map<String, ScanCondition> include);

        /**
         * <p>
         * Represents condition that when matched will allow a malware scan for a certain resource.
         * </p>
         * 
         * @param include
         *        Represents condition that when matched will allow a malware scan for a certain resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Map<ScanCriterionKey, ScanCondition> include);

        /**
         * <p>
         * Represents condition that when matched will prevent a malware scan for a certain resource.
         * </p>
         * 
         * @param exclude
         *        Represents condition that when matched will prevent a malware scan for a certain resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeWithStrings(Map<String, ScanCondition> exclude);

        /**
         * <p>
         * Represents condition that when matched will prevent a malware scan for a certain resource.
         * </p>
         * 
         * @param exclude
         *        Represents condition that when matched will prevent a malware scan for a certain resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(Map<ScanCriterionKey, ScanCondition> exclude);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ScanCondition> include = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ScanCondition> exclude = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResourceCriteria model) {
            includeWithStrings(model.include);
            excludeWithStrings(model.exclude);
        }

        public final Map<String, ScanCondition.Builder> getInclude() {
            Map<String, ScanCondition.Builder> result = ScanCriterionCopier.copyToBuilder(this.include);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInclude(Map<String, ScanCondition.BuilderImpl> include) {
            this.include = ScanCriterionCopier.copyFromBuilder(include);
        }

        @Override
        public final Builder includeWithStrings(Map<String, ScanCondition> include) {
            this.include = ScanCriterionCopier.copy(include);
            return this;
        }

        @Override
        public final Builder include(Map<ScanCriterionKey, ScanCondition> include) {
            this.include = ScanCriterionCopier.copyEnumToString(include);
            return this;
        }

        public final Map<String, ScanCondition.Builder> getExclude() {
            Map<String, ScanCondition.Builder> result = ScanCriterionCopier.copyToBuilder(this.exclude);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExclude(Map<String, ScanCondition.BuilderImpl> exclude) {
            this.exclude = ScanCriterionCopier.copyFromBuilder(exclude);
        }

        @Override
        public final Builder excludeWithStrings(Map<String, ScanCondition> exclude) {
            this.exclude = ScanCriterionCopier.copy(exclude);
            return this;
        }

        @Override
        public final Builder exclude(Map<ScanCriterionKey, ScanCondition> exclude) {
            this.exclude = ScanCriterionCopier.copyEnumToString(exclude);
            return this;
        }

        @Override
        public ScanResourceCriteria build() {
            return new ScanResourceCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
