/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether Malware Protection will be enabled as a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalwareProtectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MalwareProtectionConfiguration.Builder, MalwareProtectionConfiguration> {
    private static final SdkField<ScanEc2InstanceWithFindings> SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD = SdkField
            .<ScanEc2InstanceWithFindings> builder(MarshallingType.SDK_POJO)
            .memberName("ScanEc2InstanceWithFindings")
            .getter(getter(MalwareProtectionConfiguration::scanEc2InstanceWithFindings))
            .setter(setter(Builder::scanEc2InstanceWithFindings))
            .constructor(ScanEc2InstanceWithFindings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanEc2InstanceWithFindings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScanEc2InstanceWithFindings scanEc2InstanceWithFindings;

    private MalwareProtectionConfiguration(BuilderImpl builder) {
        this.scanEc2InstanceWithFindings = builder.scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     * 
     * @return Describes the configuration of Malware Protection for EC2 instances with findings.
     */
    public final ScanEc2InstanceWithFindings scanEc2InstanceWithFindings() {
        return scanEc2InstanceWithFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanEc2InstanceWithFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareProtectionConfiguration)) {
            return false;
        }
        MalwareProtectionConfiguration other = (MalwareProtectionConfiguration) obj;
        return Objects.equals(scanEc2InstanceWithFindings(), other.scanEc2InstanceWithFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalwareProtectionConfiguration")
                .add("ScanEc2InstanceWithFindings", scanEc2InstanceWithFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanEc2InstanceWithFindings":
            return Optional.ofNullable(clazz.cast(scanEc2InstanceWithFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MalwareProtectionConfiguration, T> g) {
        return obj -> g.apply((MalwareProtectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalwareProtectionConfiguration> {
        /**
         * <p>
         * Describes the configuration of Malware Protection for EC2 instances with findings.
         * </p>
         * 
         * @param scanEc2InstanceWithFindings
         *        Describes the configuration of Malware Protection for EC2 instances with findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanEc2InstanceWithFindings(ScanEc2InstanceWithFindings scanEc2InstanceWithFindings);

        /**
         * <p>
         * Describes the configuration of Malware Protection for EC2 instances with findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScanEc2InstanceWithFindings.Builder}
         * avoiding the need to create one manually via {@link ScanEc2InstanceWithFindings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanEc2InstanceWithFindings.Builder#build()} is called
         * immediately and its result is passed to {@link #scanEc2InstanceWithFindings(ScanEc2InstanceWithFindings)}.
         * 
         * @param scanEc2InstanceWithFindings
         *        a consumer that will call methods on {@link ScanEc2InstanceWithFindings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanEc2InstanceWithFindings(ScanEc2InstanceWithFindings)
         */
        default Builder scanEc2InstanceWithFindings(Consumer<ScanEc2InstanceWithFindings.Builder> scanEc2InstanceWithFindings) {
            return scanEc2InstanceWithFindings(ScanEc2InstanceWithFindings.builder().applyMutation(scanEc2InstanceWithFindings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScanEc2InstanceWithFindings scanEc2InstanceWithFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareProtectionConfiguration model) {
            scanEc2InstanceWithFindings(model.scanEc2InstanceWithFindings);
        }

        public final ScanEc2InstanceWithFindings.Builder getScanEc2InstanceWithFindings() {
            return scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.toBuilder() : null;
        }

        public final void setScanEc2InstanceWithFindings(ScanEc2InstanceWithFindings.BuilderImpl scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.build() : null;
        }

        @Override
        public final Builder scanEc2InstanceWithFindings(ScanEc2InstanceWithFindings scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
            return this;
        }

        @Override
        public MalwareProtectionConfiguration build() {
            return new MalwareProtectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
