/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the current bucket policies for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketPolicy implements SdkPojo, Serializable, ToCopyableBuilder<BucketPolicy.Builder, BucketPolicy> {
    private static final SdkField<Boolean> ALLOWS_PUBLIC_READ_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowsPublicReadAccess").getter(getter(BucketPolicy::allowsPublicReadAccess))
            .setter(setter(Builder::allowsPublicReadAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsPublicReadAccess").build())
            .build();

    private static final SdkField<Boolean> ALLOWS_PUBLIC_WRITE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowsPublicWriteAccess").getter(getter(BucketPolicy::allowsPublicWriteAccess))
            .setter(setter(Builder::allowsPublicWriteAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsPublicWriteAccess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOWS_PUBLIC_READ_ACCESS_FIELD, ALLOWS_PUBLIC_WRITE_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowsPublicReadAccess;

    private final Boolean allowsPublicWriteAccess;

    private BucketPolicy(BuilderImpl builder) {
        this.allowsPublicReadAccess = builder.allowsPublicReadAccess;
        this.allowsPublicWriteAccess = builder.allowsPublicWriteAccess;
    }

    /**
     * <p>
     * A value that indicates whether public read access for the bucket is enabled through a bucket policy.
     * </p>
     * 
     * @return A value that indicates whether public read access for the bucket is enabled through a bucket policy.
     */
    public final Boolean allowsPublicReadAccess() {
        return allowsPublicReadAccess;
    }

    /**
     * <p>
     * A value that indicates whether public write access for the bucket is enabled through a bucket policy.
     * </p>
     * 
     * @return A value that indicates whether public write access for the bucket is enabled through a bucket policy.
     */
    public final Boolean allowsPublicWriteAccess() {
        return allowsPublicWriteAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowsPublicReadAccess());
        hashCode = 31 * hashCode + Objects.hashCode(allowsPublicWriteAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketPolicy)) {
            return false;
        }
        BucketPolicy other = (BucketPolicy) obj;
        return Objects.equals(allowsPublicReadAccess(), other.allowsPublicReadAccess())
                && Objects.equals(allowsPublicWriteAccess(), other.allowsPublicWriteAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketPolicy").add("AllowsPublicReadAccess", allowsPublicReadAccess())
                .add("AllowsPublicWriteAccess", allowsPublicWriteAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowsPublicReadAccess":
            return Optional.ofNullable(clazz.cast(allowsPublicReadAccess()));
        case "AllowsPublicWriteAccess":
            return Optional.ofNullable(clazz.cast(allowsPublicWriteAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketPolicy, T> g) {
        return obj -> g.apply((BucketPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketPolicy> {
        /**
         * <p>
         * A value that indicates whether public read access for the bucket is enabled through a bucket policy.
         * </p>
         * 
         * @param allowsPublicReadAccess
         *        A value that indicates whether public read access for the bucket is enabled through a bucket policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowsPublicReadAccess(Boolean allowsPublicReadAccess);

        /**
         * <p>
         * A value that indicates whether public write access for the bucket is enabled through a bucket policy.
         * </p>
         * 
         * @param allowsPublicWriteAccess
         *        A value that indicates whether public write access for the bucket is enabled through a bucket policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowsPublicWriteAccess(Boolean allowsPublicWriteAccess);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowsPublicReadAccess;

        private Boolean allowsPublicWriteAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketPolicy model) {
            allowsPublicReadAccess(model.allowsPublicReadAccess);
            allowsPublicWriteAccess(model.allowsPublicWriteAccess);
        }

        public final Boolean getAllowsPublicReadAccess() {
            return allowsPublicReadAccess;
        }

        public final void setAllowsPublicReadAccess(Boolean allowsPublicReadAccess) {
            this.allowsPublicReadAccess = allowsPublicReadAccess;
        }

        @Override
        public final Builder allowsPublicReadAccess(Boolean allowsPublicReadAccess) {
            this.allowsPublicReadAccess = allowsPublicReadAccess;
            return this;
        }

        public final Boolean getAllowsPublicWriteAccess() {
            return allowsPublicWriteAccess;
        }

        public final void setAllowsPublicWriteAccess(Boolean allowsPublicWriteAccess) {
            this.allowsPublicWriteAccess = allowsPublicWriteAccess;
        }

        @Override
        public final Builder allowsPublicWriteAccess(Boolean allowsPublicWriteAccess) {
            this.allowsPublicWriteAccess = allowsPublicWriteAccess;
            return this;
        }

        @Override
        public BucketPolicy build() {
            return new BucketPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
