/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig;
import software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig;
import software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig;
import software.amazon.awssdk.services.groundstation.model.TrackingConfig;
import software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigTypeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigTypeData> {
    private static final SdkField<AntennaDownlinkConfig> ANTENNA_DOWNLINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaDownlinkConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaDownlinkConfig)).setter(ConfigTypeData.setter(Builder::antennaDownlinkConfig)).constructor(AntennaDownlinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkConfig").build()}).build();
    private static final SdkField<AntennaDownlinkDemodDecodeConfig> ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaDownlinkDemodDecodeConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaDownlinkDemodDecodeConfig)).setter(ConfigTypeData.setter(Builder::antennaDownlinkDemodDecodeConfig)).constructor(AntennaDownlinkDemodDecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkDemodDecodeConfig").build()}).build();
    private static final SdkField<AntennaUplinkConfig> ANTENNA_UPLINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaUplinkConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaUplinkConfig)).setter(ConfigTypeData.setter(Builder::antennaUplinkConfig)).constructor(AntennaUplinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaUplinkConfig").build()}).build();
    private static final SdkField<DataflowEndpointConfig> DATAFLOW_ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataflowEndpointConfig").getter(ConfigTypeData.getter(ConfigTypeData::dataflowEndpointConfig)).setter(ConfigTypeData.setter(Builder::dataflowEndpointConfig)).constructor(DataflowEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointConfig").build()}).build();
    private static final SdkField<TrackingConfig> TRACKING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trackingConfig").getter(ConfigTypeData.getter(ConfigTypeData::trackingConfig)).setter(ConfigTypeData.setter(Builder::trackingConfig)).constructor(TrackingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfig").build()}).build();
    private static final SdkField<UplinkEchoConfig> UPLINK_ECHO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("uplinkEchoConfig").getter(ConfigTypeData.getter(ConfigTypeData::uplinkEchoConfig)).setter(ConfigTypeData.setter(Builder::uplinkEchoConfig)).constructor(UplinkEchoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkEchoConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANTENNA_DOWNLINK_CONFIG_FIELD, ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD, ANTENNA_UPLINK_CONFIG_FIELD, DATAFLOW_ENDPOINT_CONFIG_FIELD, TRACKING_CONFIG_FIELD, UPLINK_ECHO_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final AntennaDownlinkConfig antennaDownlinkConfig;
    private final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;
    private final AntennaUplinkConfig antennaUplinkConfig;
    private final DataflowEndpointConfig dataflowEndpointConfig;
    private final TrackingConfig trackingConfig;
    private final UplinkEchoConfig uplinkEchoConfig;

    private ConfigTypeData(BuilderImpl builder) {
        this.antennaDownlinkConfig = builder.antennaDownlinkConfig;
        this.antennaDownlinkDemodDecodeConfig = builder.antennaDownlinkDemodDecodeConfig;
        this.antennaUplinkConfig = builder.antennaUplinkConfig;
        this.dataflowEndpointConfig = builder.dataflowEndpointConfig;
        this.trackingConfig = builder.trackingConfig;
        this.uplinkEchoConfig = builder.uplinkEchoConfig;
    }

    public final AntennaDownlinkConfig antennaDownlinkConfig() {
        return this.antennaDownlinkConfig;
    }

    public final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig() {
        return this.antennaDownlinkDemodDecodeConfig;
    }

    public final AntennaUplinkConfig antennaUplinkConfig() {
        return this.antennaUplinkConfig;
    }

    public final DataflowEndpointConfig dataflowEndpointConfig() {
        return this.dataflowEndpointConfig;
    }

    public final TrackingConfig trackingConfig() {
        return this.trackingConfig;
    }

    public final UplinkEchoConfig uplinkEchoConfig() {
        return this.uplinkEchoConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaDownlinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaDownlinkDemodDecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaUplinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkEchoConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigTypeData)) {
            return false;
        }
        ConfigTypeData other = (ConfigTypeData)obj;
        return Objects.equals(this.antennaDownlinkConfig(), other.antennaDownlinkConfig()) && Objects.equals(this.antennaDownlinkDemodDecodeConfig(), other.antennaDownlinkDemodDecodeConfig()) && Objects.equals(this.antennaUplinkConfig(), other.antennaUplinkConfig()) && Objects.equals(this.dataflowEndpointConfig(), other.dataflowEndpointConfig()) && Objects.equals(this.trackingConfig(), other.trackingConfig()) && Objects.equals(this.uplinkEchoConfig(), other.uplinkEchoConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigTypeData").add("AntennaDownlinkConfig", (Object)this.antennaDownlinkConfig()).add("AntennaDownlinkDemodDecodeConfig", (Object)this.antennaDownlinkDemodDecodeConfig()).add("AntennaUplinkConfig", (Object)this.antennaUplinkConfig()).add("DataflowEndpointConfig", (Object)this.dataflowEndpointConfig()).add("TrackingConfig", (Object)this.trackingConfig()).add("UplinkEchoConfig", (Object)this.uplinkEchoConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "antennaDownlinkConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaDownlinkConfig()));
            }
            case "antennaDownlinkDemodDecodeConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaDownlinkDemodDecodeConfig()));
            }
            case "antennaUplinkConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaUplinkConfig()));
            }
            case "dataflowEndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointConfig()));
            }
            case "trackingConfig": {
                return Optional.ofNullable(clazz.cast(this.trackingConfig()));
            }
            case "uplinkEchoConfig": {
                return Optional.ofNullable(clazz.cast(this.uplinkEchoConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigTypeData, T> g) {
        return obj -> g.apply((ConfigTypeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AntennaDownlinkConfig antennaDownlinkConfig;
        private AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;
        private AntennaUplinkConfig antennaUplinkConfig;
        private DataflowEndpointConfig dataflowEndpointConfig;
        private TrackingConfig trackingConfig;
        private UplinkEchoConfig uplinkEchoConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigTypeData model) {
            this.antennaDownlinkConfig(model.antennaDownlinkConfig);
            this.antennaDownlinkDemodDecodeConfig(model.antennaDownlinkDemodDecodeConfig);
            this.antennaUplinkConfig(model.antennaUplinkConfig);
            this.dataflowEndpointConfig(model.dataflowEndpointConfig);
            this.trackingConfig(model.trackingConfig);
            this.uplinkEchoConfig(model.uplinkEchoConfig);
        }

        public final AntennaDownlinkConfig.Builder getAntennaDownlinkConfig() {
            return this.antennaDownlinkConfig != null ? this.antennaDownlinkConfig.toBuilder() : null;
        }

        @Override
        public final Builder antennaDownlinkConfig(AntennaDownlinkConfig antennaDownlinkConfig) {
            this.antennaDownlinkConfig = antennaDownlinkConfig;
            return this;
        }

        public final void setAntennaDownlinkConfig(AntennaDownlinkConfig.BuilderImpl antennaDownlinkConfig) {
            this.antennaDownlinkConfig = antennaDownlinkConfig != null ? antennaDownlinkConfig.build() : null;
        }

        public final AntennaDownlinkDemodDecodeConfig.Builder getAntennaDownlinkDemodDecodeConfig() {
            return this.antennaDownlinkDemodDecodeConfig != null ? this.antennaDownlinkDemodDecodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig) {
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig;
            return this;
        }

        public final void setAntennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig.BuilderImpl antennaDownlinkDemodDecodeConfig) {
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig != null ? antennaDownlinkDemodDecodeConfig.build() : null;
        }

        public final AntennaUplinkConfig.Builder getAntennaUplinkConfig() {
            return this.antennaUplinkConfig != null ? this.antennaUplinkConfig.toBuilder() : null;
        }

        @Override
        public final Builder antennaUplinkConfig(AntennaUplinkConfig antennaUplinkConfig) {
            this.antennaUplinkConfig = antennaUplinkConfig;
            return this;
        }

        public final void setAntennaUplinkConfig(AntennaUplinkConfig.BuilderImpl antennaUplinkConfig) {
            this.antennaUplinkConfig = antennaUplinkConfig != null ? antennaUplinkConfig.build() : null;
        }

        public final DataflowEndpointConfig.Builder getDataflowEndpointConfig() {
            return this.dataflowEndpointConfig != null ? this.dataflowEndpointConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataflowEndpointConfig(DataflowEndpointConfig dataflowEndpointConfig) {
            this.dataflowEndpointConfig = dataflowEndpointConfig;
            return this;
        }

        public final void setDataflowEndpointConfig(DataflowEndpointConfig.BuilderImpl dataflowEndpointConfig) {
            this.dataflowEndpointConfig = dataflowEndpointConfig != null ? dataflowEndpointConfig.build() : null;
        }

        public final TrackingConfig.Builder getTrackingConfig() {
            return this.trackingConfig != null ? this.trackingConfig.toBuilder() : null;
        }

        @Override
        public final Builder trackingConfig(TrackingConfig trackingConfig) {
            this.trackingConfig = trackingConfig;
            return this;
        }

        public final void setTrackingConfig(TrackingConfig.BuilderImpl trackingConfig) {
            this.trackingConfig = trackingConfig != null ? trackingConfig.build() : null;
        }

        public final UplinkEchoConfig.Builder getUplinkEchoConfig() {
            return this.uplinkEchoConfig != null ? this.uplinkEchoConfig.toBuilder() : null;
        }

        @Override
        public final Builder uplinkEchoConfig(UplinkEchoConfig uplinkEchoConfig) {
            this.uplinkEchoConfig = uplinkEchoConfig;
            return this;
        }

        public final void setUplinkEchoConfig(UplinkEchoConfig.BuilderImpl uplinkEchoConfig) {
            this.uplinkEchoConfig = uplinkEchoConfig != null ? uplinkEchoConfig.build() : null;
        }

        public ConfigTypeData build() {
            return new ConfigTypeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigTypeData> {
        public Builder antennaDownlinkConfig(AntennaDownlinkConfig var1);

        default public Builder antennaDownlinkConfig(Consumer<AntennaDownlinkConfig.Builder> antennaDownlinkConfig) {
            return this.antennaDownlinkConfig((AntennaDownlinkConfig)((AntennaDownlinkConfig.Builder)AntennaDownlinkConfig.builder().applyMutation(antennaDownlinkConfig)).build());
        }

        public Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig var1);

        default public Builder antennaDownlinkDemodDecodeConfig(Consumer<AntennaDownlinkDemodDecodeConfig.Builder> antennaDownlinkDemodDecodeConfig) {
            return this.antennaDownlinkDemodDecodeConfig((AntennaDownlinkDemodDecodeConfig)((AntennaDownlinkDemodDecodeConfig.Builder)AntennaDownlinkDemodDecodeConfig.builder().applyMutation(antennaDownlinkDemodDecodeConfig)).build());
        }

        public Builder antennaUplinkConfig(AntennaUplinkConfig var1);

        default public Builder antennaUplinkConfig(Consumer<AntennaUplinkConfig.Builder> antennaUplinkConfig) {
            return this.antennaUplinkConfig((AntennaUplinkConfig)((AntennaUplinkConfig.Builder)AntennaUplinkConfig.builder().applyMutation(antennaUplinkConfig)).build());
        }

        public Builder dataflowEndpointConfig(DataflowEndpointConfig var1);

        default public Builder dataflowEndpointConfig(Consumer<DataflowEndpointConfig.Builder> dataflowEndpointConfig) {
            return this.dataflowEndpointConfig((DataflowEndpointConfig)((DataflowEndpointConfig.Builder)DataflowEndpointConfig.builder().applyMutation(dataflowEndpointConfig)).build());
        }

        public Builder trackingConfig(TrackingConfig var1);

        default public Builder trackingConfig(Consumer<TrackingConfig.Builder> trackingConfig) {
            return this.trackingConfig((TrackingConfig)((TrackingConfig.Builder)TrackingConfig.builder().applyMutation(trackingConfig)).build());
        }

        public Builder uplinkEchoConfig(UplinkEchoConfig var1);

        default public Builder uplinkEchoConfig(Consumer<UplinkEchoConfig.Builder> uplinkEchoConfig) {
            return this.uplinkEchoConfig((UplinkEchoConfig)((UplinkEchoConfig.Builder)UplinkEchoConfig.builder().applyMutation(uplinkEchoConfig)).build());
        }
    }
}

