/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.CoreDevice;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse;

public class ListCoreDevicesPublisher
implements SdkPublisher<ListCoreDevicesResponse> {
    private final GreengrassV2AsyncClient client;
    private final ListCoreDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoreDevicesPublisher(GreengrassV2AsyncClient client, ListCoreDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoreDevicesPublisher(GreengrassV2AsyncClient client, ListCoreDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoreDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoreDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreDevice> coreDevices() {
        Function<ListCoreDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreDevices() != null) {
                return response.coreDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoreDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoreDevicesResponseFetcher
    implements AsyncPageFetcher<ListCoreDevicesResponse> {
        private ListCoreDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoreDevicesResponse> nextPage(ListCoreDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListCoreDevicesPublisher.this.client.listCoreDevices(ListCoreDevicesPublisher.this.firstRequest);
            }
            return ListCoreDevicesPublisher.this.client.listCoreDevices((ListCoreDevicesRequest)((Object)ListCoreDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

