/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePermissionsRequest extends GrafanaRequest implements
        ToCopyableBuilder<UpdatePermissionsRequest.Builder, UpdatePermissionsRequest> {
    private static final SdkField<List<UpdateInstruction>> UPDATE_INSTRUCTION_BATCH_FIELD = SdkField
            .<List<UpdateInstruction>> builder(MarshallingType.LIST)
            .memberName("updateInstructionBatch")
            .getter(getter(UpdatePermissionsRequest::updateInstructionBatch))
            .setter(setter(Builder::updateInstructionBatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateInstructionBatch").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdatePermissionsRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UPDATE_INSTRUCTION_BATCH_FIELD, WORKSPACE_ID_FIELD));

    private final List<UpdateInstruction> updateInstructionBatch;

    private final String workspaceId;

    private UpdatePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.updateInstructionBatch = builder.updateInstructionBatch;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateInstructionBatch property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUpdateInstructionBatch() {
        return updateInstructionBatch != null && !(updateInstructionBatch instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain the permission updates to make.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateInstructionBatch} method.
     * </p>
     * 
     * @return An array of structures that contain the permission updates to make.
     */
    public final List<UpdateInstruction> updateInstructionBatch() {
        return updateInstructionBatch;
    }

    /**
     * <p>
     * The ID of the workspace to update.
     * </p>
     * 
     * @return The ID of the workspace to update.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateInstructionBatch() ? updateInstructionBatch() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePermissionsRequest)) {
            return false;
        }
        UpdatePermissionsRequest other = (UpdatePermissionsRequest) obj;
        return hasUpdateInstructionBatch() == other.hasUpdateInstructionBatch()
                && Objects.equals(updateInstructionBatch(), other.updateInstructionBatch())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePermissionsRequest")
                .add("UpdateInstructionBatch", hasUpdateInstructionBatch() ? updateInstructionBatch() : null)
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateInstructionBatch":
            return Optional.ofNullable(clazz.cast(updateInstructionBatch()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePermissionsRequest, T> g) {
        return obj -> g.apply((UpdatePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePermissionsRequest> {
        /**
         * <p>
         * An array of structures that contain the permission updates to make.
         * </p>
         * 
         * @param updateInstructionBatch
         *        An array of structures that contain the permission updates to make.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateInstructionBatch(Collection<UpdateInstruction> updateInstructionBatch);

        /**
         * <p>
         * An array of structures that contain the permission updates to make.
         * </p>
         * 
         * @param updateInstructionBatch
         *        An array of structures that contain the permission updates to make.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateInstructionBatch(UpdateInstruction... updateInstructionBatch);

        /**
         * <p>
         * An array of structures that contain the permission updates to make.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.grafana.model.UpdateInstruction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.grafana.model.UpdateInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.grafana.model.UpdateInstruction.Builder#build()} is called immediately
         * and its result is passed to {@link #updateInstructionBatch(List<UpdateInstruction>)}.
         * 
         * @param updateInstructionBatch
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.grafana.model.UpdateInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateInstructionBatch(java.util.Collection<UpdateInstruction>)
         */
        Builder updateInstructionBatch(Consumer<UpdateInstruction.Builder>... updateInstructionBatch);

        /**
         * <p>
         * The ID of the workspace to update.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private List<UpdateInstruction> updateInstructionBatch = DefaultSdkAutoConstructList.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePermissionsRequest model) {
            super(model);
            updateInstructionBatch(model.updateInstructionBatch);
            workspaceId(model.workspaceId);
        }

        public final List<UpdateInstruction.Builder> getUpdateInstructionBatch() {
            List<UpdateInstruction.Builder> result = UpdateInstructionBatchCopier.copyToBuilder(this.updateInstructionBatch);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateInstructionBatch(Collection<UpdateInstruction.BuilderImpl> updateInstructionBatch) {
            this.updateInstructionBatch = UpdateInstructionBatchCopier.copyFromBuilder(updateInstructionBatch);
        }

        @Override
        public final Builder updateInstructionBatch(Collection<UpdateInstruction> updateInstructionBatch) {
            this.updateInstructionBatch = UpdateInstructionBatchCopier.copy(updateInstructionBatch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateInstructionBatch(UpdateInstruction... updateInstructionBatch) {
            updateInstructionBatch(Arrays.asList(updateInstructionBatch));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateInstructionBatch(Consumer<UpdateInstruction.Builder>... updateInstructionBatch) {
            updateInstructionBatch(Stream.of(updateInstructionBatch)
                    .map(c -> UpdateInstruction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePermissionsRequest build() {
            return new UpdatePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
