/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the instructions for one Grafana role permission update in a <a
 * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstruction implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateInstruction.Builder, UpdateInstruction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UpdateInstruction::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(UpdateInstruction::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<List<User>> USERS_FIELD = SdkField
            .<List<User>> builder(MarshallingType.LIST)
            .memberName("users")
            .getter(getter(UpdateInstruction::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<User> builder(MarshallingType.SDK_POJO)
                                            .constructor(User::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ROLE_FIELD,
            USERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String role;

    private final List<User> users;

    private UpdateInstruction(BuilderImpl builder) {
        this.action = builder.action;
        this.role = builder.role;
        this.users = builder.users;
    }

    /**
     * <p>
     * Specifies whether this update is to add or revoke role permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether this update is to add or revoke role permissions.
     * @see UpdateAction
     */
    public final UpdateAction action() {
        return UpdateAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether this update is to add or revoke role permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether this update is to add or revoke role permissions.
     * @see UpdateAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The role to add or revoke for the user or the group specified in <code>users</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role to add or revoke for the user or the group specified in <code>users</code>.
     * @see Role
     */
    public final Role role() {
        return Role.fromValue(role);
    }

    /**
     * <p>
     * The role to add or revoke for the user or the group specified in <code>users</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role to add or revoke for the user or the group specified in <code>users</code>.
     * @see Role
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that specifies the user or group to add or revoke the role for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return A structure that specifies the user or group to add or revoke the role for.
     */
    public final List<User> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstruction)) {
            return false;
        }
        UpdateInstruction other = (UpdateInstruction) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(roleAsString(), other.roleAsString())
                && hasUsers() == other.hasUsers() && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInstruction").add("Action", actionAsString()).add("Role", roleAsString())
                .add("Users", hasUsers() ? users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstruction, T> g) {
        return obj -> g.apply((UpdateInstruction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateInstruction> {
        /**
         * <p>
         * Specifies whether this update is to add or revoke role permissions.
         * </p>
         * 
         * @param action
         *        Specifies whether this update is to add or revoke role permissions.
         * @see UpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether this update is to add or revoke role permissions.
         * </p>
         * 
         * @param action
         *        Specifies whether this update is to add or revoke role permissions.
         * @see UpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateAction
         */
        Builder action(UpdateAction action);

        /**
         * <p>
         * The role to add or revoke for the user or the group specified in <code>users</code>.
         * </p>
         * 
         * @param role
         *        The role to add or revoke for the user or the group specified in <code>users</code>.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(String role);

        /**
         * <p>
         * The role to add or revoke for the user or the group specified in <code>users</code>.
         * </p>
         * 
         * @param role
         *        The role to add or revoke for the user or the group specified in <code>users</code>.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(Role role);

        /**
         * <p>
         * A structure that specifies the user or group to add or revoke the role for.
         * </p>
         * 
         * @param users
         *        A structure that specifies the user or group to add or revoke the role for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<User> users);

        /**
         * <p>
         * A structure that specifies the user or group to add or revoke the role for.
         * </p>
         * 
         * @param users
         *        A structure that specifies the user or group to add or revoke the role for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(User... users);

        /**
         * <p>
         * A structure that specifies the user or group to add or revoke the role for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.grafana.model.User.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.grafana.model.User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.grafana.model.User.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<User>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.grafana.model.User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<User>)
         */
        Builder users(Consumer<User.Builder>... users);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String role;

        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstruction model) {
            action(model.action);
            role(model.role);
            users(model.users);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = UserListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UserListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder>... users) {
            users(Stream.of(users).map(c -> User.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateInstruction build() {
            return new UpdateInstruction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
