/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse;

public class GetColumnStatisticsTaskRunsPublisher
implements SdkPublisher<GetColumnStatisticsTaskRunsResponse> {
    private final GlueAsyncClient client;
    private final GetColumnStatisticsTaskRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetColumnStatisticsTaskRunsPublisher(GlueAsyncClient client, GetColumnStatisticsTaskRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetColumnStatisticsTaskRunsPublisher(GlueAsyncClient client, GetColumnStatisticsTaskRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetColumnStatisticsTaskRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetColumnStatisticsTaskRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetColumnStatisticsTaskRunsResponseFetcher
    implements AsyncPageFetcher<GetColumnStatisticsTaskRunsResponse> {
        private GetColumnStatisticsTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetColumnStatisticsTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetColumnStatisticsTaskRunsResponse> nextPage(GetColumnStatisticsTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return GetColumnStatisticsTaskRunsPublisher.this.client.getColumnStatisticsTaskRuns(GetColumnStatisticsTaskRunsPublisher.this.firstRequest);
            }
            return GetColumnStatisticsTaskRunsPublisher.this.client.getColumnStatisticsTaskRuns((GetColumnStatisticsTaskRunsRequest)((Object)GetColumnStatisticsTaskRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

