/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.FindMatchesMetrics;
import software.amazon.awssdk.services.glue.model.TransformType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationMetrics> {
    private static final SdkField<String> TRANSFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformType").getter(EvaluationMetrics.getter(EvaluationMetrics::transformTypeAsString)).setter(EvaluationMetrics.setter(Builder::transformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformType").build()}).build();
    private static final SdkField<FindMatchesMetrics> FIND_MATCHES_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindMatchesMetrics").getter(EvaluationMetrics.getter(EvaluationMetrics::findMatchesMetrics)).setter(EvaluationMetrics.setter(Builder::findMatchesMetrics)).constructor(FindMatchesMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_TYPE_FIELD, FIND_MATCHES_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transformType;
    private final FindMatchesMetrics findMatchesMetrics;

    private EvaluationMetrics(BuilderImpl builder) {
        this.transformType = builder.transformType;
        this.findMatchesMetrics = builder.findMatchesMetrics;
    }

    public final TransformType transformType() {
        return TransformType.fromValue(this.transformType);
    }

    public final String transformTypeAsString() {
        return this.transformType;
    }

    public final FindMatchesMetrics findMatchesMetrics() {
        return this.findMatchesMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findMatchesMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetrics)) {
            return false;
        }
        EvaluationMetrics other = (EvaluationMetrics)obj;
        return Objects.equals(this.transformTypeAsString(), other.transformTypeAsString()) && Objects.equals(this.findMatchesMetrics(), other.findMatchesMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationMetrics").add("TransformType", (Object)this.transformTypeAsString()).add("FindMatchesMetrics", (Object)this.findMatchesMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformType": {
                return Optional.ofNullable(clazz.cast(this.transformTypeAsString()));
            }
            case "FindMatchesMetrics": {
                return Optional.ofNullable(clazz.cast(this.findMatchesMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransformType", TRANSFORM_TYPE_FIELD);
        map.put("FindMatchesMetrics", FIND_MATCHES_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetrics, T> g) {
        return obj -> g.apply((EvaluationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformType;
        private FindMatchesMetrics findMatchesMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetrics model) {
            this.transformType(model.transformType);
            this.findMatchesMetrics(model.findMatchesMetrics);
        }

        public final String getTransformType() {
            return this.transformType;
        }

        public final void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        @Override
        public final Builder transformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        @Override
        public final Builder transformType(TransformType transformType) {
            this.transformType(transformType == null ? null : transformType.toString());
            return this;
        }

        public final FindMatchesMetrics.Builder getFindMatchesMetrics() {
            return this.findMatchesMetrics != null ? this.findMatchesMetrics.toBuilder() : null;
        }

        public final void setFindMatchesMetrics(FindMatchesMetrics.BuilderImpl findMatchesMetrics) {
            this.findMatchesMetrics = findMatchesMetrics != null ? findMatchesMetrics.build() : null;
        }

        @Override
        public final Builder findMatchesMetrics(FindMatchesMetrics findMatchesMetrics) {
            this.findMatchesMetrics = findMatchesMetrics;
            return this;
        }

        public EvaluationMetrics build() {
            return new EvaluationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationMetrics> {
        public Builder transformType(String var1);

        public Builder transformType(TransformType var1);

        public Builder findMatchesMetrics(FindMatchesMetrics var1);

        default public Builder findMatchesMetrics(Consumer<FindMatchesMetrics.Builder> findMatchesMetrics) {
            return this.findMatchesMetrics((FindMatchesMetrics)((FindMatchesMetrics.Builder)FindMatchesMetrics.builder().applyMutation(findMatchesMetrics)).build());
        }
    }
}

