/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ExportLabelsTaskRunProperties;
import software.amazon.awssdk.services.glue.model.FindMatchesTaskRunProperties;
import software.amazon.awssdk.services.glue.model.ImportLabelsTaskRunProperties;
import software.amazon.awssdk.services.glue.model.LabelingSetGenerationTaskRunProperties;
import software.amazon.awssdk.services.glue.model.TaskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskRunProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskRunProperties> {
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskType").getter(TaskRunProperties.getter(TaskRunProperties::taskTypeAsString)).setter(TaskRunProperties.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()}).build();
    private static final SdkField<ImportLabelsTaskRunProperties> IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportLabelsTaskRunProperties").getter(TaskRunProperties.getter(TaskRunProperties::importLabelsTaskRunProperties)).setter(TaskRunProperties.setter(Builder::importLabelsTaskRunProperties)).constructor(ImportLabelsTaskRunProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportLabelsTaskRunProperties").build()}).build();
    private static final SdkField<ExportLabelsTaskRunProperties> EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportLabelsTaskRunProperties").getter(TaskRunProperties.getter(TaskRunProperties::exportLabelsTaskRunProperties)).setter(TaskRunProperties.setter(Builder::exportLabelsTaskRunProperties)).constructor(ExportLabelsTaskRunProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportLabelsTaskRunProperties").build()}).build();
    private static final SdkField<LabelingSetGenerationTaskRunProperties> LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelingSetGenerationTaskRunProperties").getter(TaskRunProperties.getter(TaskRunProperties::labelingSetGenerationTaskRunProperties)).setter(TaskRunProperties.setter(Builder::labelingSetGenerationTaskRunProperties)).constructor(LabelingSetGenerationTaskRunProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingSetGenerationTaskRunProperties").build()}).build();
    private static final SdkField<FindMatchesTaskRunProperties> FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindMatchesTaskRunProperties").getter(TaskRunProperties.getter(TaskRunProperties::findMatchesTaskRunProperties)).setter(TaskRunProperties.setter(Builder::findMatchesTaskRunProperties)).constructor(FindMatchesTaskRunProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesTaskRunProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TYPE_FIELD, IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD, EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD, LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD, FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskRunProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskType;
    private final ImportLabelsTaskRunProperties importLabelsTaskRunProperties;
    private final ExportLabelsTaskRunProperties exportLabelsTaskRunProperties;
    private final LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties;
    private final FindMatchesTaskRunProperties findMatchesTaskRunProperties;

    private TaskRunProperties(BuilderImpl builder) {
        this.taskType = builder.taskType;
        this.importLabelsTaskRunProperties = builder.importLabelsTaskRunProperties;
        this.exportLabelsTaskRunProperties = builder.exportLabelsTaskRunProperties;
        this.labelingSetGenerationTaskRunProperties = builder.labelingSetGenerationTaskRunProperties;
        this.findMatchesTaskRunProperties = builder.findMatchesTaskRunProperties;
    }

    public final TaskType taskType() {
        return TaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public final ImportLabelsTaskRunProperties importLabelsTaskRunProperties() {
        return this.importLabelsTaskRunProperties;
    }

    public final ExportLabelsTaskRunProperties exportLabelsTaskRunProperties() {
        return this.exportLabelsTaskRunProperties;
    }

    public final LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties() {
        return this.labelingSetGenerationTaskRunProperties;
    }

    public final FindMatchesTaskRunProperties findMatchesTaskRunProperties() {
        return this.findMatchesTaskRunProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importLabelsTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportLabelsTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingSetGenerationTaskRunProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.findMatchesTaskRunProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunProperties)) {
            return false;
        }
        TaskRunProperties other = (TaskRunProperties)obj;
        return Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(this.importLabelsTaskRunProperties(), other.importLabelsTaskRunProperties()) && Objects.equals(this.exportLabelsTaskRunProperties(), other.exportLabelsTaskRunProperties()) && Objects.equals(this.labelingSetGenerationTaskRunProperties(), other.labelingSetGenerationTaskRunProperties()) && Objects.equals(this.findMatchesTaskRunProperties(), other.findMatchesTaskRunProperties());
    }

    public final String toString() {
        return ToString.builder((String)"TaskRunProperties").add("TaskType", (Object)this.taskTypeAsString()).add("ImportLabelsTaskRunProperties", (Object)this.importLabelsTaskRunProperties()).add("ExportLabelsTaskRunProperties", (Object)this.exportLabelsTaskRunProperties()).add("LabelingSetGenerationTaskRunProperties", (Object)this.labelingSetGenerationTaskRunProperties()).add("FindMatchesTaskRunProperties", (Object)this.findMatchesTaskRunProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "ImportLabelsTaskRunProperties": {
                return Optional.ofNullable(clazz.cast(this.importLabelsTaskRunProperties()));
            }
            case "ExportLabelsTaskRunProperties": {
                return Optional.ofNullable(clazz.cast(this.exportLabelsTaskRunProperties()));
            }
            case "LabelingSetGenerationTaskRunProperties": {
                return Optional.ofNullable(clazz.cast(this.labelingSetGenerationTaskRunProperties()));
            }
            case "FindMatchesTaskRunProperties": {
                return Optional.ofNullable(clazz.cast(this.findMatchesTaskRunProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskType", TASK_TYPE_FIELD);
        map.put("ImportLabelsTaskRunProperties", IMPORT_LABELS_TASK_RUN_PROPERTIES_FIELD);
        map.put("ExportLabelsTaskRunProperties", EXPORT_LABELS_TASK_RUN_PROPERTIES_FIELD);
        map.put("LabelingSetGenerationTaskRunProperties", LABELING_SET_GENERATION_TASK_RUN_PROPERTIES_FIELD);
        map.put("FindMatchesTaskRunProperties", FIND_MATCHES_TASK_RUN_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskRunProperties, T> g) {
        return obj -> g.apply((TaskRunProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskType;
        private ImportLabelsTaskRunProperties importLabelsTaskRunProperties;
        private ExportLabelsTaskRunProperties exportLabelsTaskRunProperties;
        private LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties;
        private FindMatchesTaskRunProperties findMatchesTaskRunProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunProperties model) {
            this.taskType(model.taskType);
            this.importLabelsTaskRunProperties(model.importLabelsTaskRunProperties);
            this.exportLabelsTaskRunProperties(model.exportLabelsTaskRunProperties);
            this.labelingSetGenerationTaskRunProperties(model.labelingSetGenerationTaskRunProperties);
            this.findMatchesTaskRunProperties(model.findMatchesTaskRunProperties);
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(TaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final ImportLabelsTaskRunProperties.Builder getImportLabelsTaskRunProperties() {
            return this.importLabelsTaskRunProperties != null ? this.importLabelsTaskRunProperties.toBuilder() : null;
        }

        public final void setImportLabelsTaskRunProperties(ImportLabelsTaskRunProperties.BuilderImpl importLabelsTaskRunProperties) {
            this.importLabelsTaskRunProperties = importLabelsTaskRunProperties != null ? importLabelsTaskRunProperties.build() : null;
        }

        @Override
        public final Builder importLabelsTaskRunProperties(ImportLabelsTaskRunProperties importLabelsTaskRunProperties) {
            this.importLabelsTaskRunProperties = importLabelsTaskRunProperties;
            return this;
        }

        public final ExportLabelsTaskRunProperties.Builder getExportLabelsTaskRunProperties() {
            return this.exportLabelsTaskRunProperties != null ? this.exportLabelsTaskRunProperties.toBuilder() : null;
        }

        public final void setExportLabelsTaskRunProperties(ExportLabelsTaskRunProperties.BuilderImpl exportLabelsTaskRunProperties) {
            this.exportLabelsTaskRunProperties = exportLabelsTaskRunProperties != null ? exportLabelsTaskRunProperties.build() : null;
        }

        @Override
        public final Builder exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties exportLabelsTaskRunProperties) {
            this.exportLabelsTaskRunProperties = exportLabelsTaskRunProperties;
            return this;
        }

        public final LabelingSetGenerationTaskRunProperties.Builder getLabelingSetGenerationTaskRunProperties() {
            return this.labelingSetGenerationTaskRunProperties != null ? this.labelingSetGenerationTaskRunProperties.toBuilder() : null;
        }

        public final void setLabelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties.BuilderImpl labelingSetGenerationTaskRunProperties) {
            this.labelingSetGenerationTaskRunProperties = labelingSetGenerationTaskRunProperties != null ? labelingSetGenerationTaskRunProperties.build() : null;
        }

        @Override
        public final Builder labelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties labelingSetGenerationTaskRunProperties) {
            this.labelingSetGenerationTaskRunProperties = labelingSetGenerationTaskRunProperties;
            return this;
        }

        public final FindMatchesTaskRunProperties.Builder getFindMatchesTaskRunProperties() {
            return this.findMatchesTaskRunProperties != null ? this.findMatchesTaskRunProperties.toBuilder() : null;
        }

        public final void setFindMatchesTaskRunProperties(FindMatchesTaskRunProperties.BuilderImpl findMatchesTaskRunProperties) {
            this.findMatchesTaskRunProperties = findMatchesTaskRunProperties != null ? findMatchesTaskRunProperties.build() : null;
        }

        @Override
        public final Builder findMatchesTaskRunProperties(FindMatchesTaskRunProperties findMatchesTaskRunProperties) {
            this.findMatchesTaskRunProperties = findMatchesTaskRunProperties;
            return this;
        }

        public TaskRunProperties build() {
            return new TaskRunProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskRunProperties> {
        public Builder taskType(String var1);

        public Builder taskType(TaskType var1);

        public Builder importLabelsTaskRunProperties(ImportLabelsTaskRunProperties var1);

        default public Builder importLabelsTaskRunProperties(Consumer<ImportLabelsTaskRunProperties.Builder> importLabelsTaskRunProperties) {
            return this.importLabelsTaskRunProperties((ImportLabelsTaskRunProperties)((ImportLabelsTaskRunProperties.Builder)ImportLabelsTaskRunProperties.builder().applyMutation(importLabelsTaskRunProperties)).build());
        }

        public Builder exportLabelsTaskRunProperties(ExportLabelsTaskRunProperties var1);

        default public Builder exportLabelsTaskRunProperties(Consumer<ExportLabelsTaskRunProperties.Builder> exportLabelsTaskRunProperties) {
            return this.exportLabelsTaskRunProperties((ExportLabelsTaskRunProperties)((ExportLabelsTaskRunProperties.Builder)ExportLabelsTaskRunProperties.builder().applyMutation(exportLabelsTaskRunProperties)).build());
        }

        public Builder labelingSetGenerationTaskRunProperties(LabelingSetGenerationTaskRunProperties var1);

        default public Builder labelingSetGenerationTaskRunProperties(Consumer<LabelingSetGenerationTaskRunProperties.Builder> labelingSetGenerationTaskRunProperties) {
            return this.labelingSetGenerationTaskRunProperties((LabelingSetGenerationTaskRunProperties)((LabelingSetGenerationTaskRunProperties.Builder)LabelingSetGenerationTaskRunProperties.builder().applyMutation(labelingSetGenerationTaskRunProperties)).build());
        }

        public Builder findMatchesTaskRunProperties(FindMatchesTaskRunProperties var1);

        default public Builder findMatchesTaskRunProperties(Consumer<FindMatchesTaskRunProperties.Builder> findMatchesTaskRunProperties) {
            return this.findMatchesTaskRunProperties((FindMatchesTaskRunProperties)((FindMatchesTaskRunProperties.Builder)FindMatchesTaskRunProperties.builder().applyMutation(findMatchesTaskRunProperties)).build());
        }
    }
}

