/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ExecutionClass;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.JobMode;
import software.amazon.awssdk.services.glue.model.JobRunState;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.services.glue.model.Predecessor;
import software.amazon.awssdk.services.glue.model.PredecessorListCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRun> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(JobRun.getter(JobRun::id)).setter(JobRun.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Attempt").getter(JobRun.getter(JobRun::attempt)).setter(JobRun.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()}).build();
    private static final SdkField<String> PREVIOUS_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousRunId").getter(JobRun.getter(JobRun::previousRunId)).setter(JobRun.setter(Builder::previousRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousRunId").build()}).build();
    private static final SdkField<String> TRIGGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerName").getter(JobRun.getter(JobRun::triggerName)).setter(JobRun.setter(Builder::triggerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerName").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(JobRun.getter(JobRun::jobName)).setter(JobRun.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobMode").getter(JobRun.getter(JobRun::jobModeAsString)).setter(JobRun.setter(Builder::jobMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobMode").build()}).build();
    private static final SdkField<Boolean> JOB_RUN_QUEUING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("JobRunQueuingEnabled").getter(JobRun.getter(JobRun::jobRunQueuingEnabled)).setter(JobRun.setter(Builder::jobRunQueuingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunQueuingEnabled").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(JobRun.getter(JobRun::startedOn)).setter(JobRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(JobRun.getter(JobRun::lastModifiedOn)).setter(JobRun.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(JobRun.getter(JobRun::completedOn)).setter(JobRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> JOB_RUN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunState").getter(JobRun.getter(JobRun::jobRunStateAsString)).setter(JobRun.setter(Builder::jobRunState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunState").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(JobRun.getter(JobRun::arguments)).setter(JobRun.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(JobRun.getter(JobRun::errorMessage)).setter(JobRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<List<Predecessor>> PREDECESSOR_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredecessorRuns").getter(JobRun.getter(JobRun::predecessorRuns)).setter(JobRun.setter(Builder::predecessorRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredecessorRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predecessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedCapacity").getter(JobRun.getter(JobRun::allocatedCapacity)).setter(JobRun.setter(Builder::allocatedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTime").getter(JobRun.getter(JobRun::executionTime)).setter(JobRun.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(JobRun.getter(JobRun::timeout)).setter(JobRun.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(JobRun.getter(JobRun::maxCapacity)).setter(JobRun.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(JobRun.getter(JobRun::workerTypeAsString)).setter(JobRun.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(JobRun.getter(JobRun::numberOfWorkers)).setter(JobRun.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(JobRun.getter(JobRun::securityConfiguration)).setter(JobRun.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(JobRun.getter(JobRun::logGroupName)).setter(JobRun.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationProperty").getter(JobRun.getter(JobRun::notificationProperty)).setter(JobRun.setter(Builder::notificationProperty)).constructor(NotificationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(JobRun.getter(JobRun::glueVersion)).setter(JobRun.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Double> DPU_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DPUSeconds").getter(JobRun.getter(JobRun::dpuSeconds)).setter(JobRun.setter(Builder::dpuSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUSeconds").build()}).build();
    private static final SdkField<String> EXECUTION_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionClass").getter(JobRun.getter(JobRun::executionClassAsString)).setter(JobRun.setter(Builder::executionClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionClass").build()}).build();
    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceWindow").getter(JobRun.getter(JobRun::maintenanceWindow)).setter(JobRun.setter(Builder::maintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(JobRun.getter(JobRun::profileName)).setter(JobRun.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<String> STATE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateDetail").getter(JobRun.getter(JobRun::stateDetail)).setter(JobRun.setter(Builder::stateDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTEMPT_FIELD, PREVIOUS_RUN_ID_FIELD, TRIGGER_NAME_FIELD, JOB_NAME_FIELD, JOB_MODE_FIELD, JOB_RUN_QUEUING_ENABLED_FIELD, STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, JOB_RUN_STATE_FIELD, ARGUMENTS_FIELD, ERROR_MESSAGE_FIELD, PREDECESSOR_RUNS_FIELD, ALLOCATED_CAPACITY_FIELD, EXECUTION_TIME_FIELD, TIMEOUT_FIELD, MAX_CAPACITY_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, SECURITY_CONFIGURATION_FIELD, LOG_GROUP_NAME_FIELD, NOTIFICATION_PROPERTY_FIELD, GLUE_VERSION_FIELD, DPU_SECONDS_FIELD, EXECUTION_CLASS_FIELD, MAINTENANCE_WINDOW_FIELD, PROFILE_NAME_FIELD, STATE_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Integer attempt;
    private final String previousRunId;
    private final String triggerName;
    private final String jobName;
    private final String jobMode;
    private final Boolean jobRunQueuingEnabled;
    private final Instant startedOn;
    private final Instant lastModifiedOn;
    private final Instant completedOn;
    private final String jobRunState;
    private final Map<String, String> arguments;
    private final String errorMessage;
    private final List<Predecessor> predecessorRuns;
    private final Integer allocatedCapacity;
    private final Integer executionTime;
    private final Integer timeout;
    private final Double maxCapacity;
    private final String workerType;
    private final Integer numberOfWorkers;
    private final String securityConfiguration;
    private final String logGroupName;
    private final NotificationProperty notificationProperty;
    private final String glueVersion;
    private final Double dpuSeconds;
    private final String executionClass;
    private final String maintenanceWindow;
    private final String profileName;
    private final String stateDetail;

    private JobRun(BuilderImpl builder) {
        this.id = builder.id;
        this.attempt = builder.attempt;
        this.previousRunId = builder.previousRunId;
        this.triggerName = builder.triggerName;
        this.jobName = builder.jobName;
        this.jobMode = builder.jobMode;
        this.jobRunQueuingEnabled = builder.jobRunQueuingEnabled;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.jobRunState = builder.jobRunState;
        this.arguments = builder.arguments;
        this.errorMessage = builder.errorMessage;
        this.predecessorRuns = builder.predecessorRuns;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.executionTime = builder.executionTime;
        this.timeout = builder.timeout;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.securityConfiguration = builder.securityConfiguration;
        this.logGroupName = builder.logGroupName;
        this.notificationProperty = builder.notificationProperty;
        this.glueVersion = builder.glueVersion;
        this.dpuSeconds = builder.dpuSeconds;
        this.executionClass = builder.executionClass;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.profileName = builder.profileName;
        this.stateDetail = builder.stateDetail;
    }

    public final String id() {
        return this.id;
    }

    public final Integer attempt() {
        return this.attempt;
    }

    public final String previousRunId() {
        return this.previousRunId;
    }

    public final String triggerName() {
        return this.triggerName;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobMode jobMode() {
        return JobMode.fromValue(this.jobMode);
    }

    public final String jobModeAsString() {
        return this.jobMode;
    }

    public final Boolean jobRunQueuingEnabled() {
        return this.jobRunQueuingEnabled;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final JobRunState jobRunState() {
        return JobRunState.fromValue(this.jobRunState);
    }

    public final String jobRunStateAsString() {
        return this.jobRunState;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasPredecessorRuns() {
        return this.predecessorRuns != null && !(this.predecessorRuns instanceof SdkAutoConstructList);
    }

    public final List<Predecessor> predecessorRuns() {
        return this.predecessorRuns;
    }

    @Deprecated
    public final Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public final Integer executionTime() {
        return this.executionTime;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Double maxCapacity() {
        return this.maxCapacity;
    }

    public final WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public final String workerTypeAsString() {
        return this.workerType;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public final String glueVersion() {
        return this.glueVersion;
    }

    public final Double dpuSeconds() {
        return this.dpuSeconds;
    }

    public final ExecutionClass executionClass() {
        return ExecutionClass.fromValue(this.executionClass);
    }

    public final String executionClassAsString() {
        return this.executionClass;
    }

    public final String maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String stateDetail() {
        return this.stateDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunQueuingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredecessorRuns() ? this.predecessorRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpuSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.previousRunId(), other.previousRunId()) && Objects.equals(this.triggerName(), other.triggerName()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobModeAsString(), other.jobModeAsString()) && Objects.equals(this.jobRunQueuingEnabled(), other.jobRunQueuingEnabled()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobRunStateAsString(), other.jobRunStateAsString()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasPredecessorRuns() == other.hasPredecessorRuns() && Objects.equals(this.predecessorRuns(), other.predecessorRuns()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.dpuSeconds(), other.dpuSeconds()) && Objects.equals(this.executionClassAsString(), other.executionClassAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.stateDetail(), other.stateDetail());
    }

    public final String toString() {
        return ToString.builder((String)"JobRun").add("Id", (Object)this.id()).add("Attempt", (Object)this.attempt()).add("PreviousRunId", (Object)this.previousRunId()).add("TriggerName", (Object)this.triggerName()).add("JobName", (Object)this.jobName()).add("JobMode", (Object)this.jobModeAsString()).add("JobRunQueuingEnabled", (Object)this.jobRunQueuingEnabled()).add("StartedOn", (Object)this.startedOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("CompletedOn", (Object)this.completedOn()).add("JobRunState", (Object)this.jobRunStateAsString()).add("Arguments", this.hasArguments() ? this.arguments() : null).add("ErrorMessage", (Object)this.errorMessage()).add("PredecessorRuns", this.hasPredecessorRuns() ? this.predecessorRuns() : null).add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("ExecutionTime", (Object)this.executionTime()).add("Timeout", (Object)this.timeout()).add("MaxCapacity", (Object)this.maxCapacity()).add("WorkerType", (Object)this.workerTypeAsString()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("LogGroupName", (Object)this.logGroupName()).add("NotificationProperty", (Object)this.notificationProperty()).add("GlueVersion", (Object)this.glueVersion()).add("DPUSeconds", (Object)this.dpuSeconds()).add("ExecutionClass", (Object)this.executionClassAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("ProfileName", (Object)this.profileName()).add("StateDetail", (Object)this.stateDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
            case "PreviousRunId": {
                return Optional.ofNullable(clazz.cast(this.previousRunId()));
            }
            case "TriggerName": {
                return Optional.ofNullable(clazz.cast(this.triggerName()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobMode": {
                return Optional.ofNullable(clazz.cast(this.jobModeAsString()));
            }
            case "JobRunQueuingEnabled": {
                return Optional.ofNullable(clazz.cast(this.jobRunQueuingEnabled()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "JobRunState": {
                return Optional.ofNullable(clazz.cast(this.jobRunStateAsString()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "PredecessorRuns": {
                return Optional.ofNullable(clazz.cast(this.predecessorRuns()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "DPUSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpuSeconds()));
            }
            case "ExecutionClass": {
                return Optional.ofNullable(clazz.cast(this.executionClassAsString()));
            }
            case "MaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "StateDetail": {
                return Optional.ofNullable(clazz.cast(this.stateDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobRun, T> g) {
        return obj -> g.apply((JobRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer attempt;
        private String previousRunId;
        private String triggerName;
        private String jobName;
        private String jobMode;
        private Boolean jobRunQueuingEnabled;
        private Instant startedOn;
        private Instant lastModifiedOn;
        private Instant completedOn;
        private String jobRunState;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private String errorMessage;
        private List<Predecessor> predecessorRuns = DefaultSdkAutoConstructList.getInstance();
        private Integer allocatedCapacity;
        private Integer executionTime;
        private Integer timeout;
        private Double maxCapacity;
        private String workerType;
        private Integer numberOfWorkers;
        private String securityConfiguration;
        private String logGroupName;
        private NotificationProperty notificationProperty;
        private String glueVersion;
        private Double dpuSeconds;
        private String executionClass;
        private String maintenanceWindow;
        private String profileName;
        private String stateDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.id(model.id);
            this.attempt(model.attempt);
            this.previousRunId(model.previousRunId);
            this.triggerName(model.triggerName);
            this.jobName(model.jobName);
            this.jobMode(model.jobMode);
            this.jobRunQueuingEnabled(model.jobRunQueuingEnabled);
            this.startedOn(model.startedOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.completedOn(model.completedOn);
            this.jobRunState(model.jobRunState);
            this.arguments(model.arguments);
            this.errorMessage(model.errorMessage);
            this.predecessorRuns(model.predecessorRuns);
            this.allocatedCapacity(model.allocatedCapacity);
            this.executionTime(model.executionTime);
            this.timeout(model.timeout);
            this.maxCapacity(model.maxCapacity);
            this.workerType(model.workerType);
            this.numberOfWorkers(model.numberOfWorkers);
            this.securityConfiguration(model.securityConfiguration);
            this.logGroupName(model.logGroupName);
            this.notificationProperty(model.notificationProperty);
            this.glueVersion(model.glueVersion);
            this.dpuSeconds(model.dpuSeconds);
            this.executionClass(model.executionClass);
            this.maintenanceWindow(model.maintenanceWindow);
            this.profileName(model.profileName);
            this.stateDetail(model.stateDetail);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final String getPreviousRunId() {
            return this.previousRunId;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobMode() {
            return this.jobMode;
        }

        public final void setJobMode(String jobMode) {
            this.jobMode = jobMode;
        }

        @Override
        public final Builder jobMode(String jobMode) {
            this.jobMode = jobMode;
            return this;
        }

        @Override
        public final Builder jobMode(JobMode jobMode) {
            this.jobMode(jobMode == null ? null : jobMode.toString());
            return this;
        }

        public final Boolean getJobRunQueuingEnabled() {
            return this.jobRunQueuingEnabled;
        }

        public final void setJobRunQueuingEnabled(Boolean jobRunQueuingEnabled) {
            this.jobRunQueuingEnabled = jobRunQueuingEnabled;
        }

        @Override
        public final Builder jobRunQueuingEnabled(Boolean jobRunQueuingEnabled) {
            this.jobRunQueuingEnabled = jobRunQueuingEnabled;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getJobRunState() {
            return this.jobRunState;
        }

        public final void setJobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
        }

        @Override
        public final Builder jobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
            return this;
        }

        @Override
        public final Builder jobRunState(JobRunState jobRunState) {
            this.jobRunState(jobRunState == null ? null : jobRunState.toString());
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<Predecessor.Builder> getPredecessorRuns() {
            List<Predecessor.Builder> result = PredecessorListCopier.copyToBuilder(this.predecessorRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredecessorRuns(Collection<Predecessor.BuilderImpl> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copyFromBuilder(predecessorRuns);
        }

        @Override
        public final Builder predecessorRuns(Collection<Predecessor> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copy(predecessorRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Predecessor ... predecessorRuns) {
            this.predecessorRuns(Arrays.asList(predecessorRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Consumer<Predecessor.Builder> ... predecessorRuns) {
            this.predecessorRuns(Stream.of(predecessorRuns).map(c -> (Predecessor)((Predecessor.Builder)Predecessor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Deprecated
        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        @Override
        @Deprecated
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final Integer getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Double getDpuSeconds() {
            return this.dpuSeconds;
        }

        public final void setDpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
        }

        @Override
        public final Builder dpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
            return this;
        }

        public final String getExecutionClass() {
            return this.executionClass;
        }

        public final void setExecutionClass(String executionClass) {
            this.executionClass = executionClass;
        }

        @Override
        public final Builder executionClass(String executionClass) {
            this.executionClass = executionClass;
            return this;
        }

        @Override
        public final Builder executionClass(ExecutionClass executionClass) {
            this.executionClass(executionClass == null ? null : executionClass.toString());
            return this;
        }

        public final String getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getStateDetail() {
            return this.stateDetail;
        }

        public final void setStateDetail(String stateDetail) {
            this.stateDetail = stateDetail;
        }

        @Override
        public final Builder stateDetail(String stateDetail) {
            this.stateDetail = stateDetail;
            return this;
        }

        public JobRun build() {
            return new JobRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRun> {
        public Builder id(String var1);

        public Builder attempt(Integer var1);

        public Builder previousRunId(String var1);

        public Builder triggerName(String var1);

        public Builder jobName(String var1);

        public Builder jobMode(String var1);

        public Builder jobMode(JobMode var1);

        public Builder jobRunQueuingEnabled(Boolean var1);

        public Builder startedOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder jobRunState(String var1);

        public Builder jobRunState(JobRunState var1);

        public Builder arguments(Map<String, String> var1);

        public Builder errorMessage(String var1);

        public Builder predecessorRuns(Collection<Predecessor> var1);

        public Builder predecessorRuns(Predecessor ... var1);

        public Builder predecessorRuns(Consumer<Predecessor.Builder> ... var1);

        @Deprecated
        public Builder allocatedCapacity(Integer var1);

        public Builder executionTime(Integer var1);

        public Builder timeout(Integer var1);

        public Builder maxCapacity(Double var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder securityConfiguration(String var1);

        public Builder logGroupName(String var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder glueVersion(String var1);

        public Builder dpuSeconds(Double var1);

        public Builder executionClass(String var1);

        public Builder executionClass(ExecutionClass var1);

        public Builder maintenanceWindow(String var1);

        public Builder profileName(String var1);

        public Builder stateDetail(String var1);
    }
}

