/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data lineage configuration settings for the crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageConfiguration.Builder, LineageConfiguration> {
    private static final SdkField<String> CRAWLER_LINEAGE_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerLineageSettings").getter(getter(LineageConfiguration::crawlerLineageSettingsAsString))
            .setter(setter(Builder::crawlerLineageSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerLineageSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CRAWLER_LINEAGE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String crawlerLineageSettings;

    private LineageConfiguration(BuilderImpl builder) {
        this.crawlerLineageSettings = builder.crawlerLineageSettings;
    }

    /**
     * <p>
     * Specifies whether data lineage is enabled for the crawler. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ENABLE: enables data lineage for the crawler
     * </p>
     * </li>
     * <li>
     * <p>
     * DISABLE: disables data lineage for the crawler
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #crawlerLineageSettings} will return {@link CrawlerLineageSettings#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #crawlerLineageSettingsAsString}.
     * </p>
     * 
     * @return Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ENABLE: enables data lineage for the crawler
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DISABLE: disables data lineage for the crawler
     *         </p>
     *         </li>
     * @see CrawlerLineageSettings
     */
    public final CrawlerLineageSettings crawlerLineageSettings() {
        return CrawlerLineageSettings.fromValue(crawlerLineageSettings);
    }

    /**
     * <p>
     * Specifies whether data lineage is enabled for the crawler. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ENABLE: enables data lineage for the crawler
     * </p>
     * </li>
     * <li>
     * <p>
     * DISABLE: disables data lineage for the crawler
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #crawlerLineageSettings} will return {@link CrawlerLineageSettings#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #crawlerLineageSettingsAsString}.
     * </p>
     * 
     * @return Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ENABLE: enables data lineage for the crawler
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DISABLE: disables data lineage for the crawler
     *         </p>
     *         </li>
     * @see CrawlerLineageSettings
     */
    public final String crawlerLineageSettingsAsString() {
        return crawlerLineageSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlerLineageSettingsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageConfiguration)) {
            return false;
        }
        LineageConfiguration other = (LineageConfiguration) obj;
        return Objects.equals(crawlerLineageSettingsAsString(), other.crawlerLineageSettingsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageConfiguration").add("CrawlerLineageSettings", crawlerLineageSettingsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerLineageSettings":
            return Optional.ofNullable(clazz.cast(crawlerLineageSettingsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineageConfiguration, T> g) {
        return obj -> g.apply((LineageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageConfiguration> {
        /**
         * <p>
         * Specifies whether data lineage is enabled for the crawler. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ENABLE: enables data lineage for the crawler
         * </p>
         * </li>
         * <li>
         * <p>
         * DISABLE: disables data lineage for the crawler
         * </p>
         * </li>
         * </ul>
         * 
         * @param crawlerLineageSettings
         *        Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ENABLE: enables data lineage for the crawler
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DISABLE: disables data lineage for the crawler
         *        </p>
         *        </li>
         * @see CrawlerLineageSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlerLineageSettings
         */
        Builder crawlerLineageSettings(String crawlerLineageSettings);

        /**
         * <p>
         * Specifies whether data lineage is enabled for the crawler. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ENABLE: enables data lineage for the crawler
         * </p>
         * </li>
         * <li>
         * <p>
         * DISABLE: disables data lineage for the crawler
         * </p>
         * </li>
         * </ul>
         * 
         * @param crawlerLineageSettings
         *        Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ENABLE: enables data lineage for the crawler
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DISABLE: disables data lineage for the crawler
         *        </p>
         *        </li>
         * @see CrawlerLineageSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlerLineageSettings
         */
        Builder crawlerLineageSettings(CrawlerLineageSettings crawlerLineageSettings);
    }

    static final class BuilderImpl implements Builder {
        private String crawlerLineageSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageConfiguration model) {
            crawlerLineageSettings(model.crawlerLineageSettings);
        }

        public final String getCrawlerLineageSettings() {
            return crawlerLineageSettings;
        }

        public final void setCrawlerLineageSettings(String crawlerLineageSettings) {
            this.crawlerLineageSettings = crawlerLineageSettings;
        }

        @Override
        public final Builder crawlerLineageSettings(String crawlerLineageSettings) {
            this.crawlerLineageSettings = crawlerLineageSettings;
            return this;
        }

        @Override
        public final Builder crawlerLineageSettings(CrawlerLineageSettings crawlerLineageSettings) {
            this.crawlerLineageSettings(crawlerLineageSettings == null ? null : crawlerLineageSettings.toString());
            return this;
        }

        @Override
        public LineageConfiguration build() {
            return new LineageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
