/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobRunResponse extends GlueResponse implements
        ToCopyableBuilder<GetJobRunResponse.Builder, GetJobRunResponse> {
    private static final SdkField<JobRun> JOB_RUN_FIELD = SdkField.<JobRun> builder(MarshallingType.SDK_POJO)
            .memberName("JobRun").getter(getter(GetJobRunResponse::jobRun)).setter(setter(Builder::jobRun))
            .constructor(JobRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUN_FIELD));

    private final JobRun jobRun;

    private GetJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.jobRun = builder.jobRun;
    }

    /**
     * <p>
     * The requested job-run metadata.
     * </p>
     * 
     * @return The requested job-run metadata.
     */
    public final JobRun jobRun() {
        return jobRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunResponse)) {
            return false;
        }
        GetJobRunResponse other = (GetJobRunResponse) obj;
        return Objects.equals(jobRun(), other.jobRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobRunResponse").add("JobRun", jobRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobRun":
            return Optional.ofNullable(clazz.cast(jobRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunResponse, T> g) {
        return obj -> g.apply((GetJobRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobRunResponse> {
        /**
         * <p>
         * The requested job-run metadata.
         * </p>
         * 
         * @param jobRun
         *        The requested job-run metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRun(JobRun jobRun);

        /**
         * <p>
         * The requested job-run metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobRun.Builder} avoiding the need to
         * create one manually via {@link JobRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobRun.Builder#build()} is called immediately and its result is
         * passed to {@link #jobRun(JobRun)}.
         * 
         * @param jobRun
         *        a consumer that will call methods on {@link JobRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRun(JobRun)
         */
        default Builder jobRun(Consumer<JobRun.Builder> jobRun) {
            return jobRun(JobRun.builder().applyMutation(jobRun).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private JobRun jobRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunResponse model) {
            super(model);
            jobRun(model.jobRun);
        }

        public final JobRun.Builder getJobRun() {
            return jobRun != null ? jobRun.toBuilder() : null;
        }

        public final void setJobRun(JobRun.BuilderImpl jobRun) {
            this.jobRun = jobRun != null ? jobRun.build() : null;
        }

        @Override
        public final Builder jobRun(JobRun jobRun) {
            this.jobRun = jobRun;
            return this;
        }

        @Override
        public GetJobRunResponse build() {
            return new GetJobRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
