/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.waiters.GlacierWaiter;
import software.amazon.awssdk.services.glacier.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultGlacierWaiter
implements GlacierWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final GlacierClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeVaultResponse> vaultExistsWaiter;
    private final Waiter<DescribeVaultResponse> vaultNotExistsWaiter;

    private DefaultGlacierWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (GlacierClient)GlacierClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.vaultExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVaultResponse.class).acceptors(DefaultGlacierWaiter.vaultExistsWaiterAcceptors())).overrideConfiguration(DefaultGlacierWaiter.vaultExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.vaultNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVaultResponse.class).acceptors(DefaultGlacierWaiter.vaultNotExistsWaiterAcceptors())).overrideConfiguration(DefaultGlacierWaiter.vaultNotExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeVaultResponse> waitUntilVaultExists(DescribeVaultRequest describeVaultRequest) {
        return this.vaultExistsWaiter.run(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)));
    }

    @Override
    public WaiterResponse<DescribeVaultResponse> waitUntilVaultExists(DescribeVaultRequest describeVaultRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vaultExistsWaiter.run(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)), DefaultGlacierWaiter.vaultExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVaultResponse> waitUntilVaultNotExists(DescribeVaultRequest describeVaultRequest) {
        return this.vaultNotExistsWaiter.run(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)));
    }

    @Override
    public WaiterResponse<DescribeVaultResponse> waitUntilVaultNotExists(DescribeVaultRequest describeVaultRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vaultNotExistsWaiter.run(() -> this.client.describeVault(this.applyWaitersUserAgent(describeVaultRequest)), DefaultGlacierWaiter.vaultNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeVaultResponse>> vaultExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVaultResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVaultResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultGlacierWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVaultResponse>> vaultNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVaultResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVaultResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.RETRY));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGlacierWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration vaultExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(15);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vaultNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(15);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static GlacierWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends GlacierRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GlacierRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements GlacierWaiter.Builder {
        private GlacierClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public GlacierWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public GlacierWaiter.Builder client(GlacierClient client) {
            this.client = client;
            return this;
        }

        @Override
        public GlacierWaiter build() {
            return new DefaultGlacierWaiter(this);
        }
    }
}

