/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.internal.UserAgentUtils;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;

public class ListJobsPublisher
implements SdkPublisher<ListJobsResponse> {
    private final GlacierAsyncClient client;
    private final ListJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsPublisher(GlacierAsyncClient client, ListJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsPublisher(GlacierAsyncClient client, ListJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GlacierJobDescription> jobList() {
        Function<ListJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobList() != null) {
                return response.jobList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobsResponseFetcher
    implements AsyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListJobsResponse> nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsPublisher.this.client.listJobs(ListJobsPublisher.this.firstRequest);
            }
            return ListJobsPublisher.this.client.listJobs((ListJobsRequest)((Object)ListJobsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

