/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateMultipartUploadResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, InitiateMultipartUploadResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(InitiateMultipartUploadResponse.getter(InitiateMultipartUploadResponse::location)).setter(InitiateMultipartUploadResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(InitiateMultipartUploadResponse.getter(InitiateMultipartUploadResponse::uploadId)).setter(InitiateMultipartUploadResponse.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-multipart-upload-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, UPLOAD_ID_FIELD));
    private final String location;
    private final String uploadId;

    private InitiateMultipartUploadResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.uploadId = builder.uploadId;
    }

    public final String location() {
        return this.location;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateMultipartUploadResponse)) {
            return false;
        }
        InitiateMultipartUploadResponse other = (InitiateMultipartUploadResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.uploadId(), other.uploadId());
    }

    public final String toString() {
        return ToString.builder((String)"InitiateMultipartUploadResponse").add("Location", (Object)this.location()).add("UploadId", (Object)this.uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateMultipartUploadResponse, T> g) {
        return obj -> g.apply((InitiateMultipartUploadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateMultipartUploadResponse model) {
            super(model);
            this.location(model.location);
            this.uploadId(model.uploadId);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public InitiateMultipartUploadResponse build() {
            return new InitiateMultipartUploadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitiateMultipartUploadResponse> {
        public Builder location(String var1);

        public Builder uploadId(String var1);
    }
}

