/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.ActionCode;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription;
import software.amazon.awssdk.services.glacier.model.OutputLocation;
import software.amazon.awssdk.services.glacier.model.SelectParameters;
import software.amazon.awssdk.services.glacier.model.StatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DescribeJobResponse.getter(DescribeJobResponse::jobId)).setter(DescribeJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDescription").getter(DescribeJobResponse.getter(DescribeJobResponse::jobDescription)).setter(DescribeJobResponse.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(DescribeJobResponse.getter(DescribeJobResponse::actionAsString)).setter(DescribeJobResponse.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(DescribeJobResponse.getter(DescribeJobResponse::archiveId)).setter(DescribeJobResponse.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultARN").getter(DescribeJobResponse.getter(DescribeJobResponse::vaultARN)).setter(DescribeJobResponse.setter(Builder::vaultARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(DescribeJobResponse.getter(DescribeJobResponse::creationDate)).setter(DescribeJobResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Boolean> COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Completed").getter(DescribeJobResponse.getter(DescribeJobResponse::completed)).setter(DescribeJobResponse.setter(Builder::completed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(DescribeJobResponse.getter(DescribeJobResponse::statusCodeAsString)).setter(DescribeJobResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeJobResponse.getter(DescribeJobResponse::statusMessage)).setter(DescribeJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> ARCHIVE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ArchiveSizeInBytes").getter(DescribeJobResponse.getter(DescribeJobResponse::archiveSizeInBytes)).setter(DescribeJobResponse.setter(Builder::archiveSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveSizeInBytes").build()}).build();
    private static final SdkField<Long> INVENTORY_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InventorySizeInBytes").getter(DescribeJobResponse.getter(DescribeJobResponse::inventorySizeInBytes)).setter(DescribeJobResponse.setter(Builder::inventorySizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventorySizeInBytes").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSTopic").getter(DescribeJobResponse.getter(DescribeJobResponse::snsTopic)).setter(DescribeJobResponse.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopic").build()}).build();
    private static final SdkField<String> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompletionDate").getter(DescribeJobResponse.getter(DescribeJobResponse::completionDate)).setter(DescribeJobResponse.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> SHA256_TREE_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SHA256TreeHash").getter(DescribeJobResponse.getter(DescribeJobResponse::sha256TreeHash)).setter(DescribeJobResponse.setter(Builder::sha256TreeHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SHA256TreeHash").build()}).build();
    private static final SdkField<String> ARCHIVE_SHA256_TREE_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveSHA256TreeHash").getter(DescribeJobResponse.getter(DescribeJobResponse::archiveSHA256TreeHash)).setter(DescribeJobResponse.setter(Builder::archiveSHA256TreeHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveSHA256TreeHash").build()}).build();
    private static final SdkField<String> RETRIEVAL_BYTE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalByteRange").getter(DescribeJobResponse.getter(DescribeJobResponse::retrievalByteRange)).setter(DescribeJobResponse.setter(Builder::retrievalByteRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalByteRange").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(DescribeJobResponse.getter(DescribeJobResponse::tier)).setter(DescribeJobResponse.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<InventoryRetrievalJobDescription> INVENTORY_RETRIEVAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InventoryRetrievalParameters").getter(DescribeJobResponse.getter(DescribeJobResponse::inventoryRetrievalParameters)).setter(DescribeJobResponse.setter(Builder::inventoryRetrievalParameters)).constructor(InventoryRetrievalJobDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryRetrievalParameters").build()}).build();
    private static final SdkField<String> JOB_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobOutputPath").getter(DescribeJobResponse.getter(DescribeJobResponse::jobOutputPath)).setter(DescribeJobResponse.setter(Builder::jobOutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobOutputPath").build()}).build();
    private static final SdkField<SelectParameters> SELECT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectParameters").getter(DescribeJobResponse.getter(DescribeJobResponse::selectParameters)).setter(DescribeJobResponse.setter(Builder::selectParameters)).constructor(SelectParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectParameters").build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(DescribeJobResponse.getter(DescribeJobResponse::outputLocation)).setter(DescribeJobResponse.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_DESCRIPTION_FIELD, ACTION_FIELD, ARCHIVE_ID_FIELD, VAULT_ARN_FIELD, CREATION_DATE_FIELD, COMPLETED_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, ARCHIVE_SIZE_IN_BYTES_FIELD, INVENTORY_SIZE_IN_BYTES_FIELD, SNS_TOPIC_FIELD, COMPLETION_DATE_FIELD, SHA256_TREE_HASH_FIELD, ARCHIVE_SHA256_TREE_HASH_FIELD, RETRIEVAL_BYTE_RANGE_FIELD, TIER_FIELD, INVENTORY_RETRIEVAL_PARAMETERS_FIELD, JOB_OUTPUT_PATH_FIELD, SELECT_PARAMETERS_FIELD, OUTPUT_LOCATION_FIELD));
    private final String jobId;
    private final String jobDescription;
    private final String action;
    private final String archiveId;
    private final String vaultARN;
    private final String creationDate;
    private final Boolean completed;
    private final String statusCode;
    private final String statusMessage;
    private final Long archiveSizeInBytes;
    private final Long inventorySizeInBytes;
    private final String snsTopic;
    private final String completionDate;
    private final String sha256TreeHash;
    private final String archiveSHA256TreeHash;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobDescription inventoryRetrievalParameters;
    private final String jobOutputPath;
    private final SelectParameters selectParameters;
    private final OutputLocation outputLocation;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobDescription = builder.jobDescription;
        this.action = builder.action;
        this.archiveId = builder.archiveId;
        this.vaultARN = builder.vaultARN;
        this.creationDate = builder.creationDate;
        this.completed = builder.completed;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.archiveSizeInBytes = builder.archiveSizeInBytes;
        this.inventorySizeInBytes = builder.inventorySizeInBytes;
        this.snsTopic = builder.snsTopic;
        this.completionDate = builder.completionDate;
        this.sha256TreeHash = builder.sha256TreeHash;
        this.archiveSHA256TreeHash = builder.archiveSHA256TreeHash;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
        this.jobOutputPath = builder.jobOutputPath;
        this.selectParameters = builder.selectParameters;
        this.outputLocation = builder.outputLocation;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final ActionCode action() {
        return ActionCode.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final String vaultARN() {
        return this.vaultARN;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final Boolean completed() {
        return this.completed;
    }

    public final StatusCode statusCode() {
        return StatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Long archiveSizeInBytes() {
        return this.archiveSizeInBytes;
    }

    public final Long inventorySizeInBytes() {
        return this.inventorySizeInBytes;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final String completionDate() {
        return this.completionDate;
    }

    public final String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public final String archiveSHA256TreeHash() {
        return this.archiveSHA256TreeHash;
    }

    public final String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public final String tier() {
        return this.tier;
    }

    public final InventoryRetrievalJobDescription inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public final String jobOutputPath() {
        return this.jobOutputPath;
    }

    public final SelectParameters selectParameters() {
        return this.selectParameters;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventorySizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveSHA256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryRetrievalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completed(), other.completed()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.archiveSizeInBytes(), other.archiveSizeInBytes()) && Objects.equals(this.inventorySizeInBytes(), other.inventorySizeInBytes()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.sha256TreeHash(), other.sha256TreeHash()) && Objects.equals(this.archiveSHA256TreeHash(), other.archiveSHA256TreeHash()) && Objects.equals(this.retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.inventoryRetrievalParameters(), other.inventoryRetrievalParameters()) && Objects.equals(this.jobOutputPath(), other.jobOutputPath()) && Objects.equals(this.selectParameters(), other.selectParameters()) && Objects.equals(this.outputLocation(), other.outputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobResponse").add("JobId", (Object)this.jobId()).add("JobDescription", (Object)this.jobDescription()).add("Action", (Object)this.actionAsString()).add("ArchiveId", (Object)this.archiveId()).add("VaultARN", (Object)this.vaultARN()).add("CreationDate", (Object)this.creationDate()).add("Completed", (Object)this.completed()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ArchiveSizeInBytes", (Object)this.archiveSizeInBytes()).add("InventorySizeInBytes", (Object)this.inventorySizeInBytes()).add("SNSTopic", (Object)this.snsTopic()).add("CompletionDate", (Object)this.completionDate()).add("SHA256TreeHash", (Object)this.sha256TreeHash()).add("ArchiveSHA256TreeHash", (Object)this.archiveSHA256TreeHash()).add("RetrievalByteRange", (Object)this.retrievalByteRange()).add("Tier", (Object)this.tier()).add("InventoryRetrievalParameters", (Object)this.inventoryRetrievalParameters()).add("JobOutputPath", (Object)this.jobOutputPath()).add("SelectParameters", (Object)this.selectParameters()).add("OutputLocation", (Object)this.outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "VaultARN": {
                return Optional.ofNullable(clazz.cast(this.vaultARN()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ArchiveSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.archiveSizeInBytes()));
            }
            case "InventorySizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.inventorySizeInBytes()));
            }
            case "SNSTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "SHA256TreeHash": {
                return Optional.ofNullable(clazz.cast(this.sha256TreeHash()));
            }
            case "ArchiveSHA256TreeHash": {
                return Optional.ofNullable(clazz.cast(this.archiveSHA256TreeHash()));
            }
            case "RetrievalByteRange": {
                return Optional.ofNullable(clazz.cast(this.retrievalByteRange()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "InventoryRetrievalParameters": {
                return Optional.ofNullable(clazz.cast(this.inventoryRetrievalParameters()));
            }
            case "JobOutputPath": {
                return Optional.ofNullable(clazz.cast(this.jobOutputPath()));
            }
            case "SelectParameters": {
                return Optional.ofNullable(clazz.cast(this.selectParameters()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobDescription;
        private String action;
        private String archiveId;
        private String vaultARN;
        private String creationDate;
        private Boolean completed;
        private String statusCode;
        private String statusMessage;
        private Long archiveSizeInBytes;
        private Long inventorySizeInBytes;
        private String snsTopic;
        private String completionDate;
        private String sha256TreeHash;
        private String archiveSHA256TreeHash;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobDescription inventoryRetrievalParameters;
        private String jobOutputPath;
        private SelectParameters selectParameters;
        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobDescription(model.jobDescription);
            this.action(model.action);
            this.archiveId(model.archiveId);
            this.vaultARN(model.vaultARN);
            this.creationDate(model.creationDate);
            this.completed(model.completed);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.archiveSizeInBytes(model.archiveSizeInBytes);
            this.inventorySizeInBytes(model.inventorySizeInBytes);
            this.snsTopic(model.snsTopic);
            this.completionDate(model.completionDate);
            this.sha256TreeHash(model.sha256TreeHash);
            this.archiveSHA256TreeHash(model.archiveSHA256TreeHash);
            this.retrievalByteRange(model.retrievalByteRange);
            this.tier(model.tier);
            this.inventoryRetrievalParameters(model.inventoryRetrievalParameters);
            this.jobOutputPath(model.jobOutputPath);
            this.selectParameters(model.selectParameters);
            this.outputLocation(model.outputLocation);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionCode action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(Boolean completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Boolean completed) {
            this.completed = completed;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getArchiveSizeInBytes() {
            return this.archiveSizeInBytes;
        }

        @Override
        public final Builder archiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
            return this;
        }

        public final void setArchiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
        }

        public final Long getInventorySizeInBytes() {
            return this.inventorySizeInBytes;
        }

        @Override
        public final Builder inventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
            return this;
        }

        public final void setInventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getSha256TreeHash() {
            return this.sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public final String getArchiveSHA256TreeHash() {
            return this.archiveSHA256TreeHash;
        }

        @Override
        public final Builder archiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
            return this;
        }

        public final void setArchiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobDescription.Builder getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters != null ? this.inventoryRetrievalParameters.toBuilder() : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobDescription.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build() : null;
        }

        public final String getJobOutputPath() {
            return this.jobOutputPath;
        }

        @Override
        public final Builder jobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
            return this;
        }

        public final void setJobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
        }

        public final SelectParameters.Builder getSelectParameters() {
            return this.selectParameters != null ? this.selectParameters.toBuilder() : null;
        }

        @Override
        public final Builder selectParameters(SelectParameters selectParameters) {
            this.selectParameters = selectParameters;
            return this;
        }

        public final void setSelectParameters(SelectParameters.BuilderImpl selectParameters) {
            this.selectParameters = selectParameters != null ? selectParameters.build() : null;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder jobId(String var1);

        public Builder jobDescription(String var1);

        public Builder action(String var1);

        public Builder action(ActionCode var1);

        public Builder archiveId(String var1);

        public Builder vaultARN(String var1);

        public Builder creationDate(String var1);

        public Builder completed(Boolean var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StatusCode var1);

        public Builder statusMessage(String var1);

        public Builder archiveSizeInBytes(Long var1);

        public Builder inventorySizeInBytes(Long var1);

        public Builder snsTopic(String var1);

        public Builder completionDate(String var1);

        public Builder sha256TreeHash(String var1);

        public Builder archiveSHA256TreeHash(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription var1);

        default public Builder inventoryRetrievalParameters(Consumer<InventoryRetrievalJobDescription.Builder> inventoryRetrievalParameters) {
            return this.inventoryRetrievalParameters((InventoryRetrievalJobDescription)((InventoryRetrievalJobDescription.Builder)InventoryRetrievalJobDescription.builder().applyMutation(inventoryRetrievalParameters)).build());
        }

        public Builder jobOutputPath(String var1);

        public Builder selectParameters(SelectParameters var1);

        default public Builder selectParameters(Consumer<SelectParameters.Builder> selectParameters) {
            return this.selectParameters((SelectParameters)((SelectParameters.Builder)SelectParameters.builder().applyMutation(selectParameters)).build());
        }

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }
    }
}

