/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.ConnectionIdListCopier;
import software.amazon.awssdk.services.gamesparks.model.GameSparksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisconnectPlayerResponse
extends GameSparksResponse
implements ToCopyableBuilder<Builder, DisconnectPlayerResponse> {
    private static final SdkField<List<String>> DISCONNECT_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisconnectFailures").getter(DisconnectPlayerResponse.getter(DisconnectPlayerResponse::disconnectFailures)).setter(DisconnectPlayerResponse.setter(Builder::disconnectFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectFailures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISCONNECT_SUCCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisconnectSuccesses").getter(DisconnectPlayerResponse.getter(DisconnectPlayerResponse::disconnectSuccesses)).setter(DisconnectPlayerResponse.setter(Builder::disconnectSuccesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectSuccesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCONNECT_FAILURES_FIELD, DISCONNECT_SUCCESSES_FIELD));
    private final List<String> disconnectFailures;
    private final List<String> disconnectSuccesses;

    private DisconnectPlayerResponse(BuilderImpl builder) {
        super(builder);
        this.disconnectFailures = builder.disconnectFailures;
        this.disconnectSuccesses = builder.disconnectSuccesses;
    }

    public final boolean hasDisconnectFailures() {
        return this.disconnectFailures != null && !(this.disconnectFailures instanceof SdkAutoConstructList);
    }

    public final List<String> disconnectFailures() {
        return this.disconnectFailures;
    }

    public final boolean hasDisconnectSuccesses() {
        return this.disconnectSuccesses != null && !(this.disconnectSuccesses instanceof SdkAutoConstructList);
    }

    public final List<String> disconnectSuccesses() {
        return this.disconnectSuccesses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisconnectFailures() ? this.disconnectFailures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisconnectSuccesses() ? this.disconnectSuccesses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectPlayerResponse)) {
            return false;
        }
        DisconnectPlayerResponse other = (DisconnectPlayerResponse)((Object)obj);
        return this.hasDisconnectFailures() == other.hasDisconnectFailures() && Objects.equals(this.disconnectFailures(), other.disconnectFailures()) && this.hasDisconnectSuccesses() == other.hasDisconnectSuccesses() && Objects.equals(this.disconnectSuccesses(), other.disconnectSuccesses());
    }

    public final String toString() {
        return ToString.builder((String)"DisconnectPlayerResponse").add("DisconnectFailures", this.hasDisconnectFailures() ? this.disconnectFailures() : null).add("DisconnectSuccesses", this.hasDisconnectSuccesses() ? this.disconnectSuccesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisconnectFailures": {
                return Optional.ofNullable(clazz.cast(this.disconnectFailures()));
            }
            case "DisconnectSuccesses": {
                return Optional.ofNullable(clazz.cast(this.disconnectSuccesses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisconnectPlayerResponse, T> g) {
        return obj -> g.apply((DisconnectPlayerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksResponse.BuilderImpl
    implements Builder {
        private List<String> disconnectFailures = DefaultSdkAutoConstructList.getInstance();
        private List<String> disconnectSuccesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectPlayerResponse model) {
            super(model);
            this.disconnectFailures(model.disconnectFailures);
            this.disconnectSuccesses(model.disconnectSuccesses);
        }

        public final Collection<String> getDisconnectFailures() {
            if (this.disconnectFailures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disconnectFailures;
        }

        public final void setDisconnectFailures(Collection<String> disconnectFailures) {
            this.disconnectFailures = ConnectionIdListCopier.copy(disconnectFailures);
        }

        @Override
        public final Builder disconnectFailures(Collection<String> disconnectFailures) {
            this.disconnectFailures = ConnectionIdListCopier.copy(disconnectFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectFailures(String ... disconnectFailures) {
            this.disconnectFailures(Arrays.asList(disconnectFailures));
            return this;
        }

        public final Collection<String> getDisconnectSuccesses() {
            if (this.disconnectSuccesses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disconnectSuccesses;
        }

        public final void setDisconnectSuccesses(Collection<String> disconnectSuccesses) {
            this.disconnectSuccesses = ConnectionIdListCopier.copy(disconnectSuccesses);
        }

        @Override
        public final Builder disconnectSuccesses(Collection<String> disconnectSuccesses) {
            this.disconnectSuccesses = ConnectionIdListCopier.copy(disconnectSuccesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectSuccesses(String ... disconnectSuccesses) {
            this.disconnectSuccesses(Arrays.asList(disconnectSuccesses));
            return this;
        }

        @Override
        public DisconnectPlayerResponse build() {
            return new DisconnectPlayerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisconnectPlayerResponse> {
        public Builder disconnectFailures(Collection<String> var1);

        public Builder disconnectFailures(String ... var1);

        public Builder disconnectSuccesses(Collection<String> var1);

        public Builder disconnectSuccesses(String ... var1);
    }
}

