/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateMatchmakingRuleSetResponse extends GameLiftResponse implements
        ToCopyableBuilder<ValidateMatchmakingRuleSetResponse.Builder, ValidateMatchmakingRuleSetResponse> {
    private static final SdkField<Boolean> VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Valid")
            .getter(getter(ValidateMatchmakingRuleSetResponse::valid)).setter(setter(Builder::valid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Valid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD));

    private final Boolean valid;

    private ValidateMatchmakingRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.valid = builder.valid;
    }

    /**
     * <p>
     * A response indicating whether the rule set is valid.
     * </p>
     * 
     * @return A response indicating whether the rule set is valid.
     */
    public final Boolean valid() {
        return valid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateMatchmakingRuleSetResponse)) {
            return false;
        }
        ValidateMatchmakingRuleSetResponse other = (ValidateMatchmakingRuleSetResponse) obj;
        return Objects.equals(valid(), other.valid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateMatchmakingRuleSetResponse").add("Valid", valid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Valid":
            return Optional.ofNullable(clazz.cast(valid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateMatchmakingRuleSetResponse, T> g) {
        return obj -> g.apply((ValidateMatchmakingRuleSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateMatchmakingRuleSetResponse> {
        /**
         * <p>
         * A response indicating whether the rule set is valid.
         * </p>
         * 
         * @param valid
         *        A response indicating whether the rule set is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(Boolean valid);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Boolean valid;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateMatchmakingRuleSetResponse model) {
            super(model);
            valid(model.valid);
        }

        public final Boolean getValid() {
            return valid;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public ValidateMatchmakingRuleSetResponse build() {
            return new ValidateMatchmakingRuleSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
