/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterComputeRequest extends GameLiftRequest implements
        ToCopyableBuilder<RegisterComputeRequest.Builder, RegisterComputeRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(RegisterComputeRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeName").getter(getter(RegisterComputeRequest::computeName)).setter(setter(Builder::computeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()).build();

    private static final SdkField<String> CERTIFICATE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificatePath").getter(getter(RegisterComputeRequest::certificatePath))
            .setter(setter(Builder::certificatePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePath").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(RegisterComputeRequest::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(RegisterComputeRequest::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(RegisterComputeRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            COMPUTE_NAME_FIELD, CERTIFICATE_PATH_FIELD, DNS_NAME_FIELD, IP_ADDRESS_FIELD, LOCATION_FIELD));

    private final String fleetId;

    private final String computeName;

    private final String certificatePath;

    private final String dnsName;

    private final String ipAddress;

    private final String location;

    private RegisterComputeRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.computeName = builder.computeName;
        this.certificatePath = builder.certificatePath;
        this.dnsName = builder.dnsName;
        this.ipAddress = builder.ipAddress;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet to register the compute to. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet to register the compute to. You can use either the fleet ID or ARN
     *         value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A descriptive label for the compute resource.
     * </p>
     * 
     * @return A descriptive label for the compute resource.
     */
    public final String computeName() {
        return computeName;
    }

    /**
     * <p>
     * The path to a TLS certificate on your compute resource. Amazon GameLift doesn't validate the path and
     * certificate.
     * </p>
     * 
     * @return The path to a TLS certificate on your compute resource. Amazon GameLift doesn't validate the path and
     *         certificate.
     */
    public final String certificatePath() {
        return certificatePath;
    }

    /**
     * <p>
     * The DNS name of the compute resource. Amazon GameLift requires either a DNS name or IP address.
     * </p>
     * 
     * @return The DNS name of the compute resource. Amazon GameLift requires either a DNS name or IP address.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The IP address of the compute resource. Amazon GameLift requires either a DNS name or IP address.
     * </p>
     * 
     * @return The IP address of the compute resource. Amazon GameLift requires either a DNS name or IP address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The name of a custom location to associate with the compute resource being registered.
     * </p>
     * 
     * @return The name of a custom location to associate with the compute resource being registered.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(computeName());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePath());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterComputeRequest)) {
            return false;
        }
        RegisterComputeRequest other = (RegisterComputeRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(computeName(), other.computeName())
                && Objects.equals(certificatePath(), other.certificatePath()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterComputeRequest").add("FleetId", fleetId()).add("ComputeName", computeName())
                .add("CertificatePath", certificatePath()).add("DnsName", dnsName()).add("IpAddress", ipAddress())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "ComputeName":
            return Optional.ofNullable(clazz.cast(computeName()));
        case "CertificatePath":
            return Optional.ofNullable(clazz.cast(certificatePath()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterComputeRequest, T> g) {
        return obj -> g.apply((RegisterComputeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterComputeRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to register the compute to. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to register the compute to. You can use either the fleet ID or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A descriptive label for the compute resource.
         * </p>
         * 
         * @param computeName
         *        A descriptive label for the compute resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeName(String computeName);

        /**
         * <p>
         * The path to a TLS certificate on your compute resource. Amazon GameLift doesn't validate the path and
         * certificate.
         * </p>
         * 
         * @param certificatePath
         *        The path to a TLS certificate on your compute resource. Amazon GameLift doesn't validate the path and
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePath(String certificatePath);

        /**
         * <p>
         * The DNS name of the compute resource. Amazon GameLift requires either a DNS name or IP address.
         * </p>
         * 
         * @param dnsName
         *        The DNS name of the compute resource. Amazon GameLift requires either a DNS name or IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The IP address of the compute resource. Amazon GameLift requires either a DNS name or IP address.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the compute resource. Amazon GameLift requires either a DNS name or IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The name of a custom location to associate with the compute resource being registered.
         * </p>
         * 
         * @param location
         *        The name of a custom location to associate with the compute resource being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String computeName;

        private String certificatePath;

        private String dnsName;

        private String ipAddress;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterComputeRequest model) {
            super(model);
            fleetId(model.fleetId);
            computeName(model.computeName);
            certificatePath(model.certificatePath);
            dnsName(model.dnsName);
            ipAddress(model.ipAddress);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getComputeName() {
            return computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        public final String getCertificatePath() {
            return certificatePath;
        }

        public final void setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
        }

        @Override
        public final Builder certificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterComputeRequest build() {
            return new RegisterComputeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
