/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EC2InstanceLimitListCopier {
    static List<EC2InstanceLimit> copy(Collection<? extends EC2InstanceLimit> ec2InstanceLimitListParam) {
        List<EC2InstanceLimit> list;
        if (ec2InstanceLimitListParam == null || ec2InstanceLimitListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceLimit> modifiableList = new ArrayList<>();
            ec2InstanceLimitListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EC2InstanceLimit> copyFromBuilder(Collection<? extends EC2InstanceLimit.Builder> ec2InstanceLimitListParam) {
        List<EC2InstanceLimit> list;
        if (ec2InstanceLimitListParam == null || ec2InstanceLimitListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceLimit> modifiableList = new ArrayList<>();
            ec2InstanceLimitListParam.forEach(entry -> {
                EC2InstanceLimit member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EC2InstanceLimit.Builder> copyToBuilder(Collection<? extends EC2InstanceLimit> ec2InstanceLimitListParam) {
        List<EC2InstanceLimit.Builder> list;
        if (ec2InstanceLimitListParam == null || ec2InstanceLimitListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceLimit.Builder> modifiableList = new ArrayList<>();
            ec2InstanceLimitListParam.forEach(entry -> {
                EC2InstanceLimit.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
