/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet;

public class DescribeMatchmakingRuleSetsPublisher
implements SdkPublisher<DescribeMatchmakingRuleSetsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeMatchmakingRuleSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMatchmakingRuleSetsPublisher(GameLiftAsyncClient client, DescribeMatchmakingRuleSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMatchmakingRuleSetsPublisher(GameLiftAsyncClient client, DescribeMatchmakingRuleSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMatchmakingRuleSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMatchmakingRuleSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MatchmakingRuleSet> ruleSets() {
        Function<DescribeMatchmakingRuleSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleSets() != null) {
                return response.ruleSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMatchmakingRuleSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMatchmakingRuleSetsResponseFetcher
    implements AsyncPageFetcher<DescribeMatchmakingRuleSetsResponse> {
        private DescribeMatchmakingRuleSetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMatchmakingRuleSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMatchmakingRuleSetsResponse> nextPage(DescribeMatchmakingRuleSetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMatchmakingRuleSetsPublisher.this.client.describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsPublisher.this.firstRequest);
            }
            return DescribeMatchmakingRuleSetsPublisher.this.client.describeMatchmakingRuleSets((DescribeMatchmakingRuleSetsRequest)((Object)DescribeMatchmakingRuleSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

