/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of a list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowDenyList implements SdkPojo, Serializable, ToCopyableBuilder<AllowDenyList.Builder, AllowDenyList> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AllowDenyList::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AllowDenyList::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableType").getter(getter(AllowDenyList::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(AllowDenyList::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedTime").getter(getter(AllowDenyList::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AllowDenyList::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            VARIABLE_TYPE_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String variableType;

    private final String createdTime;

    private final String updatedTime;

    private final String arn;

    private AllowDenyList(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.variableType = builder.variableType;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the list.
     * </p>
     * 
     * @return The name of the list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the list.
     * </p>
     * 
     * @return The description of the list.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The variable type of the list.
     * </p>
     * 
     * @return The variable type of the list.
     */
    public final String variableType() {
        return variableType;
    }

    /**
     * <p>
     * The time the list was created.
     * </p>
     * 
     * @return The time the list was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time the list was last updated.
     * </p>
     * 
     * @return The time the list was last updated.
     */
    public final String updatedTime() {
        return updatedTime;
    }

    /**
     * <p>
     * The ARN of the list.
     * </p>
     * 
     * @return The ARN of the list.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowDenyList)) {
            return false;
        }
        AllowDenyList other = (AllowDenyList) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(variableType(), other.variableType()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(updatedTime(), other.updatedTime()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowDenyList").add("Name", name()).add("Description", description())
                .add("VariableType", variableType()).add("CreatedTime", createdTime()).add("UpdatedTime", updatedTime())
                .add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "updatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowDenyList, T> g) {
        return obj -> g.apply((AllowDenyList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowDenyList> {
        /**
         * <p>
         * The name of the list.
         * </p>
         * 
         * @param name
         *        The name of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the list.
         * </p>
         * 
         * @param description
         *        The description of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The variable type of the list.
         * </p>
         * 
         * @param variableType
         *        The variable type of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);

        /**
         * <p>
         * The time the list was created.
         * </p>
         * 
         * @param createdTime
         *        The time the list was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The time the list was last updated.
         * </p>
         * 
         * @param updatedTime
         *        The time the list was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(String updatedTime);

        /**
         * <p>
         * The ARN of the list.
         * </p>
         * 
         * @param arn
         *        The ARN of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String variableType;

        private String createdTime;

        private String updatedTime;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowDenyList model) {
            name(model.name);
            description(model.description);
            variableType(model.variableType);
            createdTime(model.createdTime);
            updatedTime(model.updatedTime);
            arn(model.arn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVariableType() {
            return variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getUpdatedTime() {
            return updatedTime;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public AllowDenyList build() {
            return new AllowDenyList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
