/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the set of time series that are used to create the forecasts in a <code>TimeSeriesIdentifiers</code> object.
 * </p>
 * <p>
 * The <code>TimeSeriesIdentifiers</code> object needs the following information:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>DataSource</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Format</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Schema</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesSelector.Builder, TimeSeriesSelector> {
    private static final SdkField<TimeSeriesIdentifiers> TIME_SERIES_IDENTIFIERS_FIELD = SdkField
            .<TimeSeriesIdentifiers> builder(MarshallingType.SDK_POJO).memberName("TimeSeriesIdentifiers")
            .getter(getter(TimeSeriesSelector::timeSeriesIdentifiers)).setter(setter(Builder::timeSeriesIdentifiers))
            .constructor(TimeSeriesIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesIdentifiers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TIME_SERIES_IDENTIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimeSeriesIdentifiers timeSeriesIdentifiers;

    private TimeSeriesSelector(BuilderImpl builder) {
        this.timeSeriesIdentifiers = builder.timeSeriesIdentifiers;
    }

    /**
     * <p>
     * Details about the import file that contains the time series for which you want to create forecasts.
     * </p>
     * 
     * @return Details about the import file that contains the time series for which you want to create forecasts.
     */
    public final TimeSeriesIdentifiers timeSeriesIdentifiers() {
        return timeSeriesIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesIdentifiers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesSelector)) {
            return false;
        }
        TimeSeriesSelector other = (TimeSeriesSelector) obj;
        return Objects.equals(timeSeriesIdentifiers(), other.timeSeriesIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesSelector").add("TimeSeriesIdentifiers", timeSeriesIdentifiers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesIdentifiers":
            return Optional.ofNullable(clazz.cast(timeSeriesIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesSelector, T> g) {
        return obj -> g.apply((TimeSeriesSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesSelector> {
        /**
         * <p>
         * Details about the import file that contains the time series for which you want to create forecasts.
         * </p>
         * 
         * @param timeSeriesIdentifiers
         *        Details about the import file that contains the time series for which you want to create forecasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesIdentifiers(TimeSeriesIdentifiers timeSeriesIdentifiers);

        /**
         * <p>
         * Details about the import file that contains the time series for which you want to create forecasts.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesIdentifiers.Builder} avoiding
         * the need to create one manually via {@link TimeSeriesIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesIdentifiers.Builder#build()} is called immediately and
         * its result is passed to {@link #timeSeriesIdentifiers(TimeSeriesIdentifiers)}.
         * 
         * @param timeSeriesIdentifiers
         *        a consumer that will call methods on {@link TimeSeriesIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesIdentifiers(TimeSeriesIdentifiers)
         */
        default Builder timeSeriesIdentifiers(Consumer<TimeSeriesIdentifiers.Builder> timeSeriesIdentifiers) {
            return timeSeriesIdentifiers(TimeSeriesIdentifiers.builder().applyMutation(timeSeriesIdentifiers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeSeriesIdentifiers timeSeriesIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesSelector model) {
            timeSeriesIdentifiers(model.timeSeriesIdentifiers);
        }

        public final TimeSeriesIdentifiers.Builder getTimeSeriesIdentifiers() {
            return timeSeriesIdentifiers != null ? timeSeriesIdentifiers.toBuilder() : null;
        }

        public final void setTimeSeriesIdentifiers(TimeSeriesIdentifiers.BuilderImpl timeSeriesIdentifiers) {
            this.timeSeriesIdentifiers = timeSeriesIdentifiers != null ? timeSeriesIdentifiers.build() : null;
        }

        @Override
        public final Builder timeSeriesIdentifiers(TimeSeriesIdentifiers timeSeriesIdentifiers) {
            this.timeSeriesIdentifiers = timeSeriesIdentifiers;
            return this;
        }

        @Override
        public TimeSeriesSelector build() {
            return new TimeSeriesSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
