/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time boundary Forecast uses to align and aggregate your data to match your forecast frequency. Provide the unit
 * of time and the time boundary as a key value pair. If you don't provide a time boundary, Forecast uses a set of <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#default-time-boundaries">Default Time
 * Boundaries</a>.
 * </p>
 * <p>
 * For more information about aggregation, see <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html">Data Aggregation for Different Forecast
 * Frequencies</a>. For more information setting a custom time boundary, see <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#specifying-time-boundary">Specifying a
 * Time Boundary</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeAlignmentBoundary implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeAlignmentBoundary.Builder, TimeAlignmentBoundary> {
    private static final SdkField<String> MONTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Month")
            .getter(getter(TimeAlignmentBoundary::monthAsString)).setter(setter(Builder::month))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Month").build()).build();

    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(TimeAlignmentBoundary::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfWeek").getter(getter(TimeAlignmentBoundary::dayOfWeekAsString)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<Integer> HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Hour")
            .getter(getter(TimeAlignmentBoundary::hour)).setter(setter(Builder::hour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD,
            DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String month;

    private final Integer dayOfMonth;

    private final String dayOfWeek;

    private final Integer hour;

    private TimeAlignmentBoundary(BuilderImpl builder) {
        this.month = builder.month;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.hour = builder.hour;
    }

    /**
     * <p>
     * The month to use for time alignment during aggregation. The month must be in uppercase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #month} will return
     * {@link Month#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monthAsString}.
     * </p>
     * 
     * @return The month to use for time alignment during aggregation. The month must be in uppercase.
     * @see Month
     */
    public final Month month() {
        return Month.fromValue(month);
    }

    /**
     * <p>
     * The month to use for time alignment during aggregation. The month must be in uppercase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #month} will return
     * {@link Month#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monthAsString}.
     * </p>
     * 
     * @return The month to use for time alignment during aggregation. The month must be in uppercase.
     * @see Month
     */
    public final String monthAsString() {
        return month;
    }

    /**
     * <p>
     * The day of the month to use for time alignment during aggregation.
     * </p>
     * 
     * @return The day of the month to use for time alignment during aggregation.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The day of week to use for time alignment during aggregation. The day must be in uppercase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of week to use for time alignment during aggregation. The day must be in uppercase.
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of week to use for time alignment during aggregation. The day must be in uppercase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of week to use for time alignment during aggregation. The day must be in uppercase.
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The hour of day to use for time alignment during aggregation.
     * </p>
     * 
     * @return The hour of day to use for time alignment during aggregation.
     */
    public final Integer hour() {
        return hour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeAlignmentBoundary)) {
            return false;
        }
        TimeAlignmentBoundary other = (TimeAlignmentBoundary) obj;
        return Objects.equals(monthAsString(), other.monthAsString()) && Objects.equals(dayOfMonth(), other.dayOfMonth())
                && Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(hour(), other.hour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeAlignmentBoundary").add("Month", monthAsString()).add("DayOfMonth", dayOfMonth())
                .add("DayOfWeek", dayOfWeekAsString()).add("Hour", hour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Month":
            return Optional.ofNullable(clazz.cast(monthAsString()));
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "Hour":
            return Optional.ofNullable(clazz.cast(hour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeAlignmentBoundary, T> g) {
        return obj -> g.apply((TimeAlignmentBoundary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeAlignmentBoundary> {
        /**
         * <p>
         * The month to use for time alignment during aggregation. The month must be in uppercase.
         * </p>
         * 
         * @param month
         *        The month to use for time alignment during aggregation. The month must be in uppercase.
         * @see Month
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Month
         */
        Builder month(String month);

        /**
         * <p>
         * The month to use for time alignment during aggregation. The month must be in uppercase.
         * </p>
         * 
         * @param month
         *        The month to use for time alignment during aggregation. The month must be in uppercase.
         * @see Month
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Month
         */
        Builder month(Month month);

        /**
         * <p>
         * The day of the month to use for time alignment during aggregation.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month to use for time alignment during aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * The day of week to use for time alignment during aggregation. The day must be in uppercase.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of week to use for time alignment during aggregation. The day must be in uppercase.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of week to use for time alignment during aggregation. The day must be in uppercase.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of week to use for time alignment during aggregation. The day must be in uppercase.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * <p>
         * The hour of day to use for time alignment during aggregation.
         * </p>
         * 
         * @param hour
         *        The hour of day to use for time alignment during aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hour(Integer hour);
    }

    static final class BuilderImpl implements Builder {
        private String month;

        private Integer dayOfMonth;

        private String dayOfWeek;

        private Integer hour;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeAlignmentBoundary model) {
            month(model.month);
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
            hour(model.hour);
        }

        public final String getMonth() {
            return month;
        }

        public final void setMonth(String month) {
            this.month = month;
        }

        @Override
        public final Builder month(String month) {
            this.month = month;
            return this;
        }

        @Override
        public final Builder month(Month month) {
            this.month(month == null ? null : month.toString());
            return this;
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final Integer getHour() {
            return hour;
        }

        public final void setHour(Integer hour) {
            this.hour = hour;
        }

        @Override
        public final Builder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        @Override
        public TimeAlignmentBoundary build() {
            return new TimeAlignmentBoundary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
