/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetImportJobResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeDatasetImportJobResponse.Builder, DescribeDatasetImportJobResponse> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobName").getter(getter(DescribeDatasetImportJobResponse::datasetImportJobName))
            .setter(setter(Builder::datasetImportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build())
            .build();

    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobArn").getter(getter(DescribeDatasetImportJobResponse::datasetImportJobArn))
            .setter(setter(Builder::datasetImportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeDatasetImportJobResponse::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(DescribeDatasetImportJobResponse::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(DescribeDatasetImportJobResponse::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<Boolean> USE_GEOLOCATION_FOR_TIME_ZONE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseGeolocationForTimeZone")
            .getter(getter(DescribeDatasetImportJobResponse::useGeolocationForTimeZone))
            .setter(setter(Builder::useGeolocationForTimeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGeolocationForTimeZone").build())
            .build();

    private static final SdkField<String> GEOLOCATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeolocationFormat").getter(getter(DescribeDatasetImportJobResponse::geolocationFormat))
            .setter(setter(Builder::geolocationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeolocationFormat").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DescribeDatasetImportJobResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeDatasetImportJobResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<Map<String, Statistics>> FIELD_STATISTICS_FIELD = SdkField
            .<Map<String, Statistics>> builder(MarshallingType.MAP)
            .memberName("FieldStatistics")
            .getter(getter(DescribeDatasetImportJobResponse::fieldStatistics))
            .setter(setter(Builder::fieldStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldStatistics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(Statistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> DATA_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DataSize").getter(getter(DescribeDatasetImportJobResponse::dataSize)).setter(setter(Builder::dataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSize").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDatasetImportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeDatasetImportJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeDatasetImportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeDatasetImportJobResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(DescribeDatasetImportJobResponse::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportMode").getter(getter(DescribeDatasetImportJobResponse::importModeAsString))
            .setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD,
            DATASET_IMPORT_JOB_ARN_FIELD, DATASET_ARN_FIELD, TIMESTAMP_FORMAT_FIELD, TIME_ZONE_FIELD,
            USE_GEOLOCATION_FOR_TIME_ZONE_FIELD, GEOLOCATION_FORMAT_FIELD, DATA_SOURCE_FIELD,
            ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, FIELD_STATISTICS_FIELD, DATA_SIZE_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, FORMAT_FIELD, IMPORT_MODE_FIELD));

    private final String datasetImportJobName;

    private final String datasetImportJobArn;

    private final String datasetArn;

    private final String timestampFormat;

    private final String timeZone;

    private final Boolean useGeolocationForTimeZone;

    private final String geolocationFormat;

    private final DataSource dataSource;

    private final Long estimatedTimeRemainingInMinutes;

    private final Map<String, Statistics> fieldStatistics;

    private final Double dataSize;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String format;

    private final String importMode;

    private DescribeDatasetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.datasetArn = builder.datasetArn;
        this.timestampFormat = builder.timestampFormat;
        this.timeZone = builder.timeZone;
        this.useGeolocationForTimeZone = builder.useGeolocationForTimeZone;
        this.geolocationFormat = builder.geolocationFormat;
        this.dataSource = builder.dataSource;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.fieldStatistics = builder.fieldStatistics;
        this.dataSize = builder.dataSize;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.format = builder.format;
        this.importMode = builder.importMode;
    }

    /**
     * <p>
     * The name of the dataset import job.
     * </p>
     * 
     * @return The name of the dataset import job.
     */
    public final String datasetImportJobName() {
        return datasetImportJobName;
    }

    /**
     * <p>
     * The ARN of the dataset import job.
     * </p>
     * 
     * @return The ARN of the dataset import job.
     */
    public final String datasetImportJobArn() {
        return datasetImportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The format of timestamps in the dataset. The format that you specify depends on the <code>DataFrequency</code>
     * specified when the dataset was created. The following formats are supported
     * </p>
     * <ul>
     * <li>
     * <p>
     * "yyyy-MM-dd"
     * </p>
     * <p>
     * For the following data frequencies: Y, M, W, and D
     * </p>
     * </li>
     * <li>
     * <p>
     * "yyyy-MM-dd HH:mm:ss"
     * </p>
     * <p>
     * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     * </p>
     * </li>
     * </ul>
     * 
     * @return The format of timestamps in the dataset. The format that you specify depends on the
     *         <code>DataFrequency</code> specified when the dataset was created. The following formats are
     *         supported</p>
     *         <ul>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd"
     *         </p>
     *         <p>
     *         For the following data frequencies: Y, M, W, and D
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd HH:mm:ss"
     *         </p>
     *         <p>
     *         For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     *         </p>
     *         </li>
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    /**
     * <p>
     * The single time zone applied to every item in the dataset
     * </p>
     * 
     * @return The single time zone applied to every item in the dataset
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * Whether <code>TimeZone</code> is automatically derived from the geolocation attribute.
     * </p>
     * 
     * @return Whether <code>TimeZone</code> is automatically derived from the geolocation attribute.
     */
    public final Boolean useGeolocationForTimeZone() {
        return useGeolocationForTimeZone;
    }

    /**
     * <p>
     * The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and <code>"CC_POSTALCODE"</code>.
     * </p>
     * 
     * @return The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
     *         <code>"CC_POSTALCODE"</code>.
     */
    public final String geolocationFormat() {
        return geolocationFormat;
    }

    /**
     * <p>
     * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast
     * can assume to access the data.
     * </p>
     * <p>
     * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
     * </p>
     * 
     * @return The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
     *         Forecast can assume to access the data.</p>
     *         <p>
     *         If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The estimated time remaining in minutes for the dataset import job to complete.
     * </p>
     * 
     * @return The estimated time remaining in minutes for the dataset import job to complete.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldStatistics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldStatistics() {
        return fieldStatistics != null && !(fieldStatistics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Statistical information about each field in the input data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldStatistics} method.
     * </p>
     * 
     * @return Statistical information about each field in the input data.
     */
    public final Map<String, Statistics> fieldStatistics() {
        return fieldStatistics;
    }

    /**
     * <p>
     * The size of the dataset in gigabytes (GB) after the import job has finished.
     * </p>
     * 
     * @return The size of the dataset in gigabytes (GB) after the import job has finished.
     */
    public final Double dataSize() {
        return dataSize;
    }

    /**
     * <p>
     * The status of the dataset import job. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the dataset import job. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the dataset import job was created.
     * </p>
     * 
     * @return When the dataset import job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The format of the imported data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the imported data, CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link ImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return The import mode of the dataset import job, FULL or INCREMENTAL.
     * @see ImportMode
     */
    public final ImportMode importMode() {
        return ImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link ImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return The import mode of the dataset import job, FULL or INCREMENTAL.
     * @see ImportMode
     */
    public final String importModeAsString() {
        return importMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(useGeolocationForTimeZone());
        hashCode = 31 * hashCode + Objects.hashCode(geolocationFormat());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldStatistics() ? fieldStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSize());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetImportJobResponse)) {
            return false;
        }
        DescribeDatasetImportJobResponse other = (DescribeDatasetImportJobResponse) obj;
        return Objects.equals(datasetImportJobName(), other.datasetImportJobName())
                && Objects.equals(datasetImportJobArn(), other.datasetImportJobArn())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(timestampFormat(), other.timestampFormat())
                && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(useGeolocationForTimeZone(), other.useGeolocationForTimeZone())
                && Objects.equals(geolocationFormat(), other.geolocationFormat())
                && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && hasFieldStatistics() == other.hasFieldStatistics()
                && Objects.equals(fieldStatistics(), other.fieldStatistics()) && Objects.equals(dataSize(), other.dataSize())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(format(), other.format()) && Objects.equals(importModeAsString(), other.importModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetImportJobResponse").add("DatasetImportJobName", datasetImportJobName())
                .add("DatasetImportJobArn", datasetImportJobArn()).add("DatasetArn", datasetArn())
                .add("TimestampFormat", timestampFormat()).add("TimeZone", timeZone())
                .add("UseGeolocationForTimeZone", useGeolocationForTimeZone()).add("GeolocationFormat", geolocationFormat())
                .add("DataSource", dataSource()).add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes())
                .add("FieldStatistics", hasFieldStatistics() ? fieldStatistics() : null).add("DataSize", dataSize())
                .add("Status", status()).add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("Format", format())
                .add("ImportMode", importModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobName":
            return Optional.ofNullable(clazz.cast(datasetImportJobName()));
        case "DatasetImportJobArn":
            return Optional.ofNullable(clazz.cast(datasetImportJobArn()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "UseGeolocationForTimeZone":
            return Optional.ofNullable(clazz.cast(useGeolocationForTimeZone()));
        case "GeolocationFormat":
            return Optional.ofNullable(clazz.cast(geolocationFormat()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "FieldStatistics":
            return Optional.ofNullable(clazz.cast(fieldStatistics()));
        case "DataSize":
            return Optional.ofNullable(clazz.cast(dataSize()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetImportJobResponse, T> g) {
        return obj -> g.apply((DescribeDatasetImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDatasetImportJobResponse> {
        /**
         * <p>
         * The name of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobName
         *        The name of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobName(String datasetImportJobName);

        /**
         * <p>
         * The ARN of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobArn
         *        The ARN of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArn(String datasetImportJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset that the training data was imported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The format of timestamps in the dataset. The format that you specify depends on the
         * <code>DataFrequency</code> specified when the dataset was created. The following formats are supported
         * </p>
         * <ul>
         * <li>
         * <p>
         * "yyyy-MM-dd"
         * </p>
         * <p>
         * For the following data frequencies: Y, M, W, and D
         * </p>
         * </li>
         * <li>
         * <p>
         * "yyyy-MM-dd HH:mm:ss"
         * </p>
         * <p>
         * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         * </p>
         * </li>
         * </ul>
         * 
         * @param timestampFormat
         *        The format of timestamps in the dataset. The format that you specify depends on the
         *        <code>DataFrequency</code> specified when the dataset was created. The following formats are
         *        supported</p>
         *        <ul>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd"
         *        </p>
         *        <p>
         *        For the following data frequencies: Y, M, W, and D
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd HH:mm:ss"
         *        </p>
         *        <p>
         *        For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        /**
         * <p>
         * The single time zone applied to every item in the dataset
         * </p>
         * 
         * @param timeZone
         *        The single time zone applied to every item in the dataset
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Whether <code>TimeZone</code> is automatically derived from the geolocation attribute.
         * </p>
         * 
         * @param useGeolocationForTimeZone
         *        Whether <code>TimeZone</code> is automatically derived from the geolocation attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone);

        /**
         * <p>
         * The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
         * <code>"CC_POSTALCODE"</code>.
         * </p>
         * 
         * @param geolocationFormat
         *        The format of the geolocation attribute. Valid Values:<code>"LAT_LONG"</code> and
         *        <code>"CC_POSTALCODE"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geolocationFormat(String geolocationFormat);

        /**
         * <p>
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * </p>
         * 
         * @param dataSource
         *        The location of the training data to import and an Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the data.</p>
         *        <p>
         *        If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The estimated time remaining in minutes for the dataset import job to complete.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The estimated time remaining in minutes for the dataset import job to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * Statistical information about each field in the input data.
         * </p>
         * 
         * @param fieldStatistics
         *        Statistical information about each field in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldStatistics(Map<String, Statistics> fieldStatistics);

        /**
         * <p>
         * The size of the dataset in gigabytes (GB) after the import job has finished.
         * </p>
         * 
         * @param dataSize
         *        The size of the dataset in gigabytes (GB) after the import job has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSize(Double dataSize);

        /**
         * <p>
         * The status of the dataset import job. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dataset import job. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the dataset import job was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The format of the imported data, CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the imported data, CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         * </p>
         * 
         * @param importMode
         *        The import mode of the dataset import job, FULL or INCREMENTAL.
         * @see ImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         * </p>
         * 
         * @param importMode
         *        The import mode of the dataset import job, FULL or INCREMENTAL.
         * @see ImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportMode
         */
        Builder importMode(ImportMode importMode);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String datasetImportJobName;

        private String datasetImportJobArn;

        private String datasetArn;

        private String timestampFormat;

        private String timeZone;

        private Boolean useGeolocationForTimeZone;

        private String geolocationFormat;

        private DataSource dataSource;

        private Long estimatedTimeRemainingInMinutes;

        private Map<String, Statistics> fieldStatistics = DefaultSdkAutoConstructMap.getInstance();

        private Double dataSize;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String format;

        private String importMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetImportJobResponse model) {
            super(model);
            datasetImportJobName(model.datasetImportJobName);
            datasetImportJobArn(model.datasetImportJobArn);
            datasetArn(model.datasetArn);
            timestampFormat(model.timestampFormat);
            timeZone(model.timeZone);
            useGeolocationForTimeZone(model.useGeolocationForTimeZone);
            geolocationFormat(model.geolocationFormat);
            dataSource(model.dataSource);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            fieldStatistics(model.fieldStatistics);
            dataSize(model.dataSize);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            format(model.format);
            importMode(model.importMode);
        }

        public final String getDatasetImportJobName() {
            return datasetImportJobName;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final String getDatasetImportJobArn() {
            return datasetImportJobArn;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Boolean getUseGeolocationForTimeZone() {
            return useGeolocationForTimeZone;
        }

        public final void setUseGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
        }

        @Override
        public final Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
            return this;
        }

        public final String getGeolocationFormat() {
            return geolocationFormat;
        }

        public final void setGeolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
        }

        @Override
        public final Builder geolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final Map<String, Statistics.Builder> getFieldStatistics() {
            Map<String, Statistics.Builder> result = FieldStatisticsCopier.copyToBuilder(this.fieldStatistics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFieldStatistics(Map<String, Statistics.BuilderImpl> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copyFromBuilder(fieldStatistics);
        }

        @Override
        public final Builder fieldStatistics(Map<String, Statistics> fieldStatistics) {
            this.fieldStatistics = FieldStatisticsCopier.copy(fieldStatistics);
            return this;
        }

        public final Double getDataSize() {
            return dataSize;
        }

        public final void setDataSize(Double dataSize) {
            this.dataSize = dataSize;
        }

        @Override
        public final Builder dataSize(Double dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getImportMode() {
            return importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(ImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        @Override
        public DescribeDatasetImportJobResponse build() {
            return new DescribeDatasetImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
