/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThirdPartyFirewallFirewallPoliciesResponse extends FmsResponse implements
        ToCopyableBuilder<ListThirdPartyFirewallFirewallPoliciesResponse.Builder, ListThirdPartyFirewallFirewallPoliciesResponse> {
    private static final SdkField<List<ThirdPartyFirewallFirewallPolicy>> THIRD_PARTY_FIREWALL_FIREWALL_POLICIES_FIELD = SdkField
            .<List<ThirdPartyFirewallFirewallPolicy>> builder(MarshallingType.LIST)
            .memberName("ThirdPartyFirewallFirewallPolicies")
            .getter(getter(ListThirdPartyFirewallFirewallPoliciesResponse::thirdPartyFirewallFirewallPolicies))
            .setter(setter(Builder::thirdPartyFirewallFirewallPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallFirewallPolicies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThirdPartyFirewallFirewallPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThirdPartyFirewallFirewallPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListThirdPartyFirewallFirewallPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            THIRD_PARTY_FIREWALL_FIREWALL_POLICIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ThirdPartyFirewallFirewallPolicy> thirdPartyFirewallFirewallPolicies;

    private final String nextToken;

    private ListThirdPartyFirewallFirewallPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.thirdPartyFirewallFirewallPolicies = builder.thirdPartyFirewallFirewallPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThirdPartyFirewallFirewallPolicies
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasThirdPartyFirewallFirewallPolicies() {
        return thirdPartyFirewallFirewallPolicies != null
                && !(thirdPartyFirewallFirewallPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party firewall
     * policies that the specified third-party firewall vendor is associated with. Each
     * <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThirdPartyFirewallFirewallPolicies}
     * method.
     * </p>
     * 
     * @return A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
     *         firewall policies that the specified third-party firewall vendor is associated with. Each
     *         <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
     */
    public final List<ThirdPartyFirewallFirewallPolicy> thirdPartyFirewallFirewallPolicies() {
        return thirdPartyFirewallFirewallPolicies;
    }

    /**
     * <p>
     * The value that you will use for <code>NextToken</code> in the next
     * <code>ListThirdPartyFirewallFirewallPolicies</code> request.
     * </p>
     * 
     * @return The value that you will use for <code>NextToken</code> in the next
     *         <code>ListThirdPartyFirewallFirewallPolicies</code> request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasThirdPartyFirewallFirewallPolicies() ? thirdPartyFirewallFirewallPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThirdPartyFirewallFirewallPoliciesResponse)) {
            return false;
        }
        ListThirdPartyFirewallFirewallPoliciesResponse other = (ListThirdPartyFirewallFirewallPoliciesResponse) obj;
        return hasThirdPartyFirewallFirewallPolicies() == other.hasThirdPartyFirewallFirewallPolicies()
                && Objects.equals(thirdPartyFirewallFirewallPolicies(), other.thirdPartyFirewallFirewallPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListThirdPartyFirewallFirewallPoliciesResponse")
                .add("ThirdPartyFirewallFirewallPolicies",
                        hasThirdPartyFirewallFirewallPolicies() ? thirdPartyFirewallFirewallPolicies() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThirdPartyFirewallFirewallPolicies":
            return Optional.ofNullable(clazz.cast(thirdPartyFirewallFirewallPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThirdPartyFirewallFirewallPoliciesResponse, T> g) {
        return obj -> g.apply((ListThirdPartyFirewallFirewallPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListThirdPartyFirewallFirewallPoliciesResponse> {
        /**
         * <p>
         * A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
         * firewall policies that the specified third-party firewall vendor is associated with. Each
         * <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
         * </p>
         * 
         * @param thirdPartyFirewallFirewallPolicies
         *        A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
         *        firewall policies that the specified third-party firewall vendor is associated with. Each
         *        <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thirdPartyFirewallFirewallPolicies(Collection<ThirdPartyFirewallFirewallPolicy> thirdPartyFirewallFirewallPolicies);

        /**
         * <p>
         * A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
         * firewall policies that the specified third-party firewall vendor is associated with. Each
         * <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
         * </p>
         * 
         * @param thirdPartyFirewallFirewallPolicies
         *        A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
         *        firewall policies that the specified third-party firewall vendor is associated with. Each
         *        <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thirdPartyFirewallFirewallPolicies(ThirdPartyFirewallFirewallPolicy... thirdPartyFirewallFirewallPolicies);

        /**
         * <p>
         * A list that contains one <code>ThirdPartyFirewallFirewallPolicies</code> element for each third-party
         * firewall policies that the specified third-party firewall vendor is associated with. Each
         * <code>ThirdPartyFirewallFirewallPolicies</code> element contains the firewall policy name and ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #thirdPartyFirewallFirewallPolicies(List<ThirdPartyFirewallFirewallPolicy>)}.
         * 
         * @param thirdPartyFirewallFirewallPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thirdPartyFirewallFirewallPolicies(java.util.Collection<ThirdPartyFirewallFirewallPolicy>)
         */
        Builder thirdPartyFirewallFirewallPolicies(
                Consumer<ThirdPartyFirewallFirewallPolicy.Builder>... thirdPartyFirewallFirewallPolicies);

        /**
         * <p>
         * The value that you will use for <code>NextToken</code> in the next
         * <code>ListThirdPartyFirewallFirewallPolicies</code> request.
         * </p>
         * 
         * @param nextToken
         *        The value that you will use for <code>NextToken</code> in the next
         *        <code>ListThirdPartyFirewallFirewallPolicies</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private List<ThirdPartyFirewallFirewallPolicy> thirdPartyFirewallFirewallPolicies = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThirdPartyFirewallFirewallPoliciesResponse model) {
            super(model);
            thirdPartyFirewallFirewallPolicies(model.thirdPartyFirewallFirewallPolicies);
            nextToken(model.nextToken);
        }

        public final List<ThirdPartyFirewallFirewallPolicy.Builder> getThirdPartyFirewallFirewallPolicies() {
            List<ThirdPartyFirewallFirewallPolicy.Builder> result = ThirdPartyFirewallFirewallPoliciesCopier
                    .copyToBuilder(this.thirdPartyFirewallFirewallPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThirdPartyFirewallFirewallPolicies(
                Collection<ThirdPartyFirewallFirewallPolicy.BuilderImpl> thirdPartyFirewallFirewallPolicies) {
            this.thirdPartyFirewallFirewallPolicies = ThirdPartyFirewallFirewallPoliciesCopier
                    .copyFromBuilder(thirdPartyFirewallFirewallPolicies);
        }

        @Override
        public final Builder thirdPartyFirewallFirewallPolicies(
                Collection<ThirdPartyFirewallFirewallPolicy> thirdPartyFirewallFirewallPolicies) {
            this.thirdPartyFirewallFirewallPolicies = ThirdPartyFirewallFirewallPoliciesCopier
                    .copy(thirdPartyFirewallFirewallPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thirdPartyFirewallFirewallPolicies(
                ThirdPartyFirewallFirewallPolicy... thirdPartyFirewallFirewallPolicies) {
            thirdPartyFirewallFirewallPolicies(Arrays.asList(thirdPartyFirewallFirewallPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thirdPartyFirewallFirewallPolicies(
                Consumer<ThirdPartyFirewallFirewallPolicy.Builder>... thirdPartyFirewallFirewallPolicies) {
            thirdPartyFirewallFirewallPolicies(Stream.of(thirdPartyFirewallFirewallPolicies)
                    .map(c -> ThirdPartyFirewallFirewallPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThirdPartyFirewallFirewallPoliciesResponse build() {
            return new ListThirdPartyFirewallFirewallPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
