/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClient;
import software.amazon.awssdk.services.finspacedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroup;

public class ListPermissionGroupsIterable
implements SdkIterable<ListPermissionGroupsResponse> {
    private final FinspaceDataClient client;
    private final ListPermissionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionGroupsIterable(FinspaceDataClient client, ListPermissionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPermissionGroupsResponseFetcher();
    }

    public Iterator<ListPermissionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PermissionGroup> permissionGroups() {
        Function<ListPermissionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionGroups() != null) {
                return response.permissionGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPermissionGroupsResponseFetcher
    implements SyncPageFetcher<ListPermissionGroupsResponse> {
        private ListPermissionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionGroupsResponse nextPage(ListPermissionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionGroupsIterable.this.client.listPermissionGroups(ListPermissionGroupsIterable.this.firstRequest);
            }
            return ListPermissionGroupsIterable.this.client.listPermissionGroups((ListPermissionGroupsRequest)((Object)ListPermissionGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

